﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.ServiceModel;
using KsiegaGosci.ReferencjaDoUslugiWpisy;

namespace KsiegaGosci
{
    public partial class Default : System.Web.UI.Page
    {
        //bool ZapiszDoPlikuPoKażdymDodaniuWpisu = true;

        protected void Page_Load(object sender, EventArgs e)
        {
            WyświetlanieWpisów();
        }

        protected void Page_Init(object sender, EventArgs e)
        {
            if (TextBox1.Text == "")
            {
                string nazwaUżytkownika = PrzypomnijNazwęUżytkownika();
                if (nazwaUżytkownika != null) TextBox1.Text = nazwaUżytkownika;
            }
        }

        #region Wyświetlanie wpisów
        const string kolorParzysty = "navy";
        const string kolorNieparzysty = "blue";
        
        private static string KolorNagłówka(int numerWpisu)
        {
            return (numerWpisu % 2 == 0) ? kolorParzysty : kolorNieparzysty;
        }

        private static string ConvertToHTMLString(Wpis wpis, string kolorNagłówka)
        {
            string nagłówek = "<FONT COLOR='" + kolorNagłówka + "'><B> Dodano dnia " + wpis.Data.ToString() + "</B></FONT>";
            string treść = wpis.Treść.Trim().Replace("\n", "<BR>");
            string podpis = "<I>" + wpis.NazwaUżytkownika + "</I> (" + wpis.AdresIP + ")";
            return nagłówek + "<BR>" + treść + "<BR>" + podpis + "<P> <HR WIDTH='30%' ALIGN='left'>";
        }
        
        private void WyświetlanieWpisów(bool odwróćKolejność = true)
        {
            Wpis[] wpisy;
            using (UslugaWpisyClient klientUslugi = new UslugaWpisyClient())
            {
                wpisy = klientUslugi.PobierzWszystkieWpisy();
            }
            
            string trescWpisow = "";
            if (!odwróćKolejność) for (int i = 0; i < wpisy.Count(); ++i) trescWpisow += ConvertToHTMLString(wpisy[i], KolorNagłówka(i));
            else for (int i = wpisy.Count() - 1; i >= 0; --i) trescWpisow += ConvertToHTMLString(wpisy[i], KolorNagłówka(i));
            Label1.Text = trescWpisow;
        }
        #endregion

        //kontroler (tylko tu model może być zmieniany)
        protected void Button1_Click(object sender, EventArgs e)
        {
            if (TextBox1.Text == "" || TextBox2.Text == "") return; //walidacja po stronie serwera

            Wpis nowyWpis = new Wpis()
            {
                NazwaUżytkownika = TextBox1.Text.Trim(),
                Treść = TextBox2.Text.Trim(),
                Data = DateTime.Now,
                AdresIP = Request.UserHostAddress
            };
            using (UslugaWpisyClient klientUslugi = new UslugaWpisyClient())
            {
                klientUslugi.DodajWpis(nowyWpis);
            }

            WyświetlanieWpisów();

            TextBox2.Text = ""; //czyszczenie pola edycyjnego z treścią wpisu
            ZapamietajNazwęUżytkownika(TextBox1.Text); //zapis do cookie
        }

        #region Przechowywanie nazwy użytkownika w ciasteczku
        void ZapamietajNazwęUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie("imie", nazwaUżytkownika);
            ciasteczko.Expires = DateTime.Today.AddDays(3);
            Response.Cookies.Add(ciasteczko);
        }

        string PrzypomnijNazwęUżytkownika()
        {
            if (Request.Cookies["imie"] != null) return Request.Cookies["imie"].Value;
            else return null;
        }
        #endregion
    }
}