﻿#if DEBUG
#warning Pamiętaj, aby przed publikacją skompilować w wersji "Release"
#endif

#if DEBUG
#warning Kompilacja "debug"
#else
#warning Kompilacja "release"
#endif

#define Web
#if Web
using System.Web.UI.WebControls;
#else
   using System.Windows.Forms;
#endif

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
//using System.Web.UI.WebControls;

namespace JezykCS
{
    public partial class Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            #if DEBUG
            Title = "Kompilacja \"debug\"";
            #endif

            PrzestarzalaMetoda();
        }

        #region Podstawowe typy danych
        protected void Button1_Click(object sender, EventArgs e)
        {
            int i = 1;
            long l = 1L;
            string s = "Helion";
            float f = 1.0f;
            double d = 1.0;

            var vi = 5;
            var vl = 5L;
            var vs = "Helion";
            var vf = 1.0f;
            var vd = 1.0;

            Label1.Text = "<b>Wyniki:</b><br />";
            byte x1 = 74, z1 = (byte)(~x1); Label1.Text += "" + z1 + "<br />";
            byte x2 = 74, y2 = 15, z2 = (byte)(x2 & y2); Label1.Text += "" + z2 + "<br />";

            Object o = new Button();
            if (o is Button) Label1.Text += "Obiekt jest przyciskiem<br />";
            else Label1.Text += "Obiekt nie jest przyciskiem<br />";
            Label1.Text += o.GetType().FullName + "<br />";

            //dalsze instrukcje mają jedynie usunąć ostrzeżenia o nieużywanych zmiennych
            Label1.Text += "<p>i=" + i.ToString() + ", l=" + l.ToString() + ", s=" + s + ", f=" + f.ToString() + ", d=" + d.ToString() + "<br />vi=" + vi.ToString() + ", vl=" + vl.ToString() + ", vs=" + vs + ", vf=" + vf.ToString() + ", vd=" + vd.ToString();
        }

        protected void Button2_Click(object sender, EventArgs e)
        {
            //string
            string s = "abc---";
            s += "xyz";
            s = s.Replace("---", " ijk ");
            Label1.Text = s + "<br />";

            //StringBuilder
            System.Text.StringBuilder sb = new System.Text.StringBuilder("abc---");
            sb.Append("xyz");
            sb.Replace("---", " ijk ");
            Label1.Text += sb.ToString() + "<br />";
        }

        public enum DniTygodnia : byte { niedziela = 1, poniedzialek, wtorek, sroda, czwartek, piatek, sobota };

        protected void Button3_Click(object sender, EventArgs e)
        {            
            DniTygodnia pn=DniTygodnia.poniedzialek;
            //byte nrDniaTygodnia=(byte)DniTygodnia.poniedzialek;
            byte nrDniaTygodnia = (byte)pn;
        }

        protected void Button4_Click(object sender, EventArgs e)
        {
            Lazy<int> li = new Lazy<int>(() => 1); //deklaracja zmiennej i wskazanie funkcji
            Label1.Text = li.IsValueCreated.ToString() + "<br />"; //jeszcze niezainicjowana
            Label1.Text += "Odwołanie do zmiennej, li=" + li.Value + "<br />"; //leniwa inicjacja
            Label1.Text += li.IsValueCreated.ToString() + "<p>"; //już zainicjowana

            Lazy<Button> lb = new Lazy<Button>(() =>
            {
                Button b = new Button();
                b.Text = "Leniwy przycisk";
                
                //this.form1.Controls.Add(b);
                Panel1.Controls.Add(b);
                return b;
            });
            Label1.Text += lb.IsValueCreated.ToString() + "<br />";
            Label1.Text += "Odwołanie do zmiennej, etykieta przycisku: \"" + lb.Value.Text + "\"<br />";
            Label1.Text += lb.IsValueCreated.ToString() + "<br />";
        }
        #endregion

        #region Metody
        void Metoda() //głowa metody, sygnatura
        {
            Label2.Text += "Hello World!<br />"; //ciało metody
        }

        /*
        void Metoda(string tekst)
        {
            Label2.Text += tekst + "<br />";
        }
        */

        void Metoda(string tekst, bool dodajZnacznikNowejLinii = true)
        {
            Label2.Text += tekst;
            if(dodajZnacznikNowejLinii) Label2.Text += "<br />";
        }

        protected void Button5_Click(object sender, EventArgs e)
        {
            Label2.Text = "";
            Metoda();
            Metoda("Witaj świecie!");
            Metoda("Witaj świecie!",true);

            Metoda(dodajZnacznikNowejLinii: true, tekst: "Witaj świecie!");
            Metoda(tekst: "Witaj świecie!", dodajZnacznikNowejLinii: true);
        }

        private int Kwadrat(byte arg)
        {
            return arg * arg;
        }

        protected void Button6_Click(object sender, EventArgs e)
        {
            int wynik = Kwadrat(2);
            Label2.Text = wynik.ToString();
        }
        
        private void zakresDouble(ref double min, out double max)
        {
            min = double.MinValue;
            max = double.MaxValue;
            Label2.Text += "Liczby double mogą należeć do przedziału (" + min + "," + max + ")<br />";
        }

        protected void Button7_Click(object sender, EventArgs e)
        {
            Label2.Text = "";
            double min = 0, max = 0;
            zakresDouble(ref min, out max);
            Label2.Text += "Liczby double mogą należeć do przedziału (" + min + "," + max + ")<br />";
        }

        delegate int Delegacja(byte arg); //typ
        Delegacja ReferencjaKwadrat; //instancja

        private void obiekt_MetodaZakonczona(object sender, DateTime czasZakonczeniaMetody)
        {
            Label2.Text += "Zakonczona metoda obiektu typu " + sender.GetType().Name + " (czas: " + czasZakonczeniaMetody.ToString() + ")<br />";
        }

        protected void Button8_Click(object sender, EventArgs e)
        {
            //referencja do metody
            Delegacja ReferencjaDoMetodyKwadrat = Kwadrat;

            int i = Kwadrat(2);
            int j = ReferencjaDoMetodyKwadrat(2);
            Label2.Text = "i=" + i + ", j=" + j;

            ReferencjaKwadrat += Kwadrat;
            int k = ReferencjaKwadrat(2);
            Label2.Text += ", k=" + k;

            //zdarzenie
            Label2.Text += "<p>";
            Klasa obiekt = new Klasa();

            //subskrypcja zdarzenia
            obiekt.DelegacjaMetodaZakonczona = obiekt_MetodaZakonczona;
            obiekt.ZdarzenieMetodaZakonczona += obiekt_MetodaZakonczona;

            obiekt.DelegacjaMetodaZakonczona(obiekt, DateTime.Now);
            //obiekt.ZdarzenieMetodaZakonczona(obiekt, DateTime.Now);

            if (obiekt.DelegacjaMetodaZakonczona == null) Label2.Text += "Delegacja nie przypisana<br />";
            //if (obiekt.ZdarzenieMetodaZakonczona == null) Label2.Text += "Zdarzenie nie przypisane<br />";

            //uruchomienie metody, ktora wywola metode zdarzeniowa
            obiekt.Metoda(Label2);
        }

        delegate int DInc(int n);
        delegate bool DIsEqual(double x, double y);
        delegate void DShow(int n);

        protected void Button9_Click(object sender, EventArgs e)
        {
            DInc Inc = (int n) => n + 1;
            Label2.Text = "Inc(1)=" + Inc(1);

            DIsEqual IsEqual = (x, y) => x == y;
            int a = 10;
            int b = 20;
            Label2.Text += "<br />Czy równe a=" + a + " i b=" + b + "? " + (IsEqual(a, b) ? "Tak" : "Nie");
            Label2.Text += "<br />Czy równe a=" + a + " i a=" + a + "? " + (IsEqual(a, a) ? "Tak" : "Nie");

            DShow Show = n => { Label2.Text += "<br />" + n.ToString(); };
            Show(10);

            string[] slowa = { "czereśnia", "jabłko", "borówka", "wiśnia", "jagoda" };
            //int dlugoscNajkrotszego = slowa.Min(delegate(string slowo) { return slowo.Length; });
            int dlugoscNajkrotszego = slowa.Min(slowo => slowo.Length);
            Label2.Text += "<br />Długość najkrótszego słowa: " + dlugoscNajkrotszego;            
        }
        #endregion

        #region Wyswietlanie komunikatow w oknie dialogowym
        private void ShowMessage1(string komunikat) 
        {
            komunikat = komunikat.Replace("\n", "\\n").Replace("\r", "").Replace("'", "\\'");
            
            System.Text.StringBuilder sb = new System.Text.StringBuilder(); 
            sb.Append("alert('");
            sb.Append(komunikat); 
            sb.Append("');"); 
            
            ScriptManager.RegisterStartupScript(this.Page, this.GetType(), "showmessage", sb.ToString(), true); 
        }

        private void ShowMessage2(string komunikat)
        {
            komunikat = komunikat.Replace("\n", "\\n").Replace("\r", "").Replace("'", "\\'");
            
            System.Text.StringBuilder sb = new System.Text.StringBuilder(); 
            sb.Append("<SCRIPT LANGUAGE='JavaScript'>alert('");
            sb.Append(komunikat); 
            sb.Append("')</SCRIPT>"); 

            System.Web.HttpContext.Current.Response.Write(sb.ToString());
        }
        #endregion

        #region Typy wartosciowe i referencyjne
        protected void Button10_Click(object sender, EventArgs e)
        {
            Button b = new Button();

            Int32 i1 = new Int32();
            int i2 = new int();
            int i = 1;

            Button a = b;
            int j = i;

            //dalsze instrukcje mają jedynie usunąć ostrzeżenia o nieużywanych zmiennych
            Label3.Text = "i1=" + i1 + ", i2=" + i2;
        }

        protected void Button11_Click(object sender, EventArgs e)
        {
            //Nullable<int> ni = 1;
            int? ni = 1;
            int i1;
            if (ni.HasValue)
            {
                i1 = ni.Value;
            }
            else
            {
                i1 = default(int);
            }
            int i2 = ni.GetValueOrDefault();
            Label3.Text = "i1=" + i1 + ", i2=" + i2;

            int i3 = (ni == null) ? -1 : ni.Value;
            int i4 = ni ?? -1;
        }

        protected void Button12_Click(object sender, EventArgs e)
        {
            int i = 1;
            object o = i;
            Label3.Text = o.GetType().ToString(); //zwraca System.Int32

            int j = (int)o;
            Label3.Text += "<br />" + j.ToString();
        }
        #endregion

        #region Typy dynamiczne
        protected void Button13_Click(object sender, EventArgs e)
        {
            dynamic o; //nie działa IntelliSense
            o = 5; Label4.Text = o.ToString() + ", " + o.GetType().FullName;
            o = 5L; Label4.Text += "<br />" + o.ToString() + ", " + o.GetType().FullName;
            o = "Helion"; Label4.Text += "<br />" + o.ToString() + ", " + o.GetType().FullName;
            o = 1.0f; Label4.Text += "<br />" + o.ToString() + ", " + o.GetType().FullName;
            o = 1.0; Label4.Text += "<br />" + o.ToString() + ", " + o.GetType().FullName;
        }

        dynamic obiekt; //pole

        dynamic Obiekt //własność
        {
            get
            {
                return zwrocObiekt();
            }
            set
            {
                obiekt = value;
            }
        }

        dynamic zwrocObiekt(int ktoryObiekt = 0) //wartość zwracana przez metodę
        {
            dynamic wartosc;
            switch (ktoryObiekt)
            {
                case 0: wartosc = 5; break;
                case 1: wartosc = 5L; break;
                case 2: wartosc = "Helion"; break;
                case 3: wartosc = 1.0f; break;
                case 4: wartosc = 1.0; break;
                case 5: wartosc = Button1; break;
                default: wartosc = obiekt; break;
            }
            return wartosc;
        } 

        protected void Button14_Click(object sender, EventArgs e)
        {
            try
            {
                dynamic o = zwrocObiekt(DropDownList1.SelectedIndex);
                Label4.Text = "<br />Obiekt: " + o.ToString() + ", typ: " + o.GetType().FullName;
                o.Metoda(); //tu pojawi się wyjątek
            }
            catch (Exception exc)
            {
                Label4.Text += "<br /><font color=red>Błąd: " + exc.Message + "</font>";
            }
        }

        protected void Button15_Click(object sender, EventArgs e)
        {
            object o;
            o = 5; Label4.Text = o.ToString() + ", " + o.GetType().FullName;
            o = 5L; Label4.Text += "<br />" + o.ToString() + ", " + o.GetType().FullName;
            o = "Helion"; Label4.Text += "<br />" + o.ToString() + ", " + o.GetType().FullName;
            o = 1.0f; Label4.Text += "<br />" + o.ToString() + ", " + o.GetType().FullName;
            o = 1.0; Label4.Text += "<br />" + o.ToString() + ", " + o.GetType().FullName;
        }
        #endregion

        #region Sterowanie przepływem
        protected void Button16_Click(object sender, EventArgs e)
        {
            Random r = new Random();
            int n = r.Next(8);
            Label5.Text = n.ToString();

            //Składnia podstawowa if
            if (n < 6) Label5.Text += "<br />Wylosowana liczba jest mniejsza od 6.";

            //Składnia rozszerzona if..else
            if (n <= 4) Label5.Text += "<br />Wylosowana liczba jest mniejsza lub równa 4.";
            else Label5.Text += "<br />Wylosowana liczba jest większa od 4.";
        }

        protected void Button17_Click(object sender, EventArgs e)
        {
            Random r = new Random();
            int n = r.Next(8);
            string opis;
            switch (n)
            {
                case 1: opis = "niedziela"; break;
                case 2: opis = "poniedziałek"; break;
                case 3: opis = "wtorek"; break;
                case 4: opis = "środa"; break;
                case 5: opis = "czwartek"; break;
                case 6: opis = "piątek"; break;
                case 7: opis = "sobota"; break;
                default: opis = "błąd!"; break;
            }
            Label5.Text = "Dzień tygodnia: " + n + ", " + opis;
        }

        long silnia(byte arg)
        {
            if (arg == 0) return 0;
            long wartosc = 1;
            for (byte i = 1; i <= arg; i++)
                wartosc *= i;
            return wartosc;
        }

        long najwiekszyDzielnik(long arg)
        {
            long dzielnik = arg - 1;
            while (arg % dzielnik != 0)
                dzielnik--;
            return dzielnik;
        }

        protected void Button18_Click(object sender, EventArgs e)
        {
            Label5.Text = "5!=" + silnia(5);
            Label5.Text += "<br />Największy dzielnik 10 to " + najwiekszyDzielnik(10);

            //Przykład pętli do..while
            Random r = new Random();
            int n = r.Next(8);
            //Zadanie komputera to odgadnąć 
            //liczbę z zakresu od 0 do 7
            int z; int licznik = 0;
            do
            {
                licznik++;
                z = r.Next(8);
            }
            while (n != z);
            Label5.Text += "<br />Komputer zgadł liczbę " + z + " po " + licznik + " próbach!";

            //Instrukcja continue
            for (int i = -1; i <= 1; i++)
                for (int j = -1; j <= 1; j++)
                {
                    if (i == 0 && j == 0) continue; //pomijamy przypadki, gdy obie zmienne równe są 0
                    Label5.Text += "<br />i=" + i + ", j=" + j;
                }

        }
#endregion

        #region Wyjatki
        protected void Button19_Click(object sender, EventArgs e)
        {
            try
            {
                int x = 0;
                int y = 1 / x;
                Label6.Text += "<br />To polecenie nie zostanie wykonane!";
            }
            catch (DivideByZeroException exc)
            {
                Label6.Text += "<br /><font color=red>Dzielenie przez zero (" + exc.Message + ")</font>";
                return; //mimo tej instrukcji kod z sekcji finally zostanie wykonany
            }
            catch (ArithmeticException exc)
            {
                Label1.Text += "<br /><font color=red>Błąd arytmetyki (" + exc.Message + ")</font>";
            }
            catch (Exception exc)
            {
                Label6.Text += "<br /><font color=red>Wyjątek: " + exc.Message + "</font>";
            }
            finally
            {
                Label6.Text += "<br />Kod wykonywany w każdym przypadku";
            }
        }

        protected void Button20_Click(object sender, EventArgs e)
        {
            int x = 0;
            int y = 1 / x;
        }

        protected void Button21_Click(object sender, EventArgs e)
        {
            try
            {
                throw new Exception("Komunikat opisujący błąd");
            }
            catch (Exception exc)
            {
                Label6.Text += "<br /><font color=red>Wyjątek: " + exc.Message + "</font>";
            }
        }
        #endregion

        [Obsolete("Metoda przestarzała. Lepiej użyj metody NowaMetoda", false)]
        void PrzestarzalaMetoda()
        {
            //warunkiem pojawienia sie ostrzezenia jest wywolanie metody (jest w Page_Load)
        }

        #region Kolekcje
        protected void Button22_Click(object sender, EventArgs e)
        {
            int[] ti = new int[3] { 1, 2, 4 };

            //Button[] tb = new Button[3] { new Button(), new Button(), new Button() };
            //Label7.Text = tb[0].Text;

            Button[] tb = new Button[3];
            for (int i = 0; i < tb.Length; i++)
            {
                tb[i] = new Button();
                tb[i].Text = "" + i;
                //this.form1.Controls.Add(tb[i]);
                Panel2.Controls.Add(tb[i]);
            }

            //int[,] ti2 = new int[2, 3] { { 0, 1, 2 }, { 3, 4, 5 } };

            int[,] ti2 = new int[2, 3];
            for (int i = 0; i < 2; i++)
                for (int j = 0; j < 3; j++)
                    ti2[i, j] = 3 * i + j;

            Label7.Text += "<br />"; 
            foreach (Button bi in tb)
            {
                bi.Text = "Numer: " + bi.Text;
                Label7.Text += bi.Text + ", ";
            }

            //błąd
            //foreach (int i in ti) i = 1;

            /*
            foreach (Button bi in tb)
            {
                bi = new Button(); //błąd
                bi.Text = "Numer: " + bi.Text;
                Label7.Text += bi.Text;
            }
            */

            Label7.Text += "<br />";
            //int[,] ti2 = new int[2, 3] { { 0, 1, 2 }, { 3, 4, 5 } };
            foreach (int i in ti2) Label7.Text += "" + i;
            
            Label7.Text += "<br />";
            foreach(var i in ti2) Label7.Text += "" + i;
        }

        protected void Button23_Click(object sender, EventArgs e)
        {
            int[] losy = new int[30];
            Random r = new Random();
            for (int indeks = 0; indeks < losy.Length; indeks++)
                losy[indeks] = r.Next(100);

            string s = "Przed sortowaniem: ";
            foreach (int los in losy) s += los.ToString() + " ";
            Label7.Text = s;

            Array.Sort(losy);

            s = "Po sortowaniu: ";
            foreach (int los in losy) s += los.ToString() + " ";
            Label7.Text += "<br />" + s;
        }

        protected void Button24_Click(object sender, EventArgs e)
        {
            //uruchomienie tego kodu skończy się błędem
            Button[] przyciski = new Button[100];
            Random r = new Random();
            for (int indeks = 0; indeks < przyciski.Length; indeks++)
            {
                przyciski[indeks] = new Button();
                przyciski[indeks].Text = "" + r.Next(100);
            }
            Array.Sort(przyciski);
        }

        protected void Button25_Click(object sender, EventArgs e)
        {
            int rozmiar = 30;
            Random r = new Random();
            List<int> a = new List<int>(new int[rozmiar]);
            for (int i = 0; i < rozmiar; i++) a[i] = r.Next(100);
            a.AddRange(new int[10]);
            int[] i5 = { -1, -1, -1, -1, -1 };
            a.InsertRange(rozmiar / 2, i5);
            a.Insert(0, 1);

            /*
            //tu kryją się błędy
            for (int i = 0; i < rozmiar; i++)
            {
                if (a[i] > 20)
                    a.RemoveAt(i);
            }
            */

            /*
            //lepiej, ale nadal z błędem
            for (int i = 0; i < a.Count; i++)
            {
                if (a[i] > 20)
                    a.RemoveAt(i);
            }
            */

            for (int i = 0; i < a.Count; i++)
            {
                if (a[i] > 20)
                {
                    a.RemoveAt(i);
                    i--;
                }
            }

            a.Sort();

            string s = "Elementy listy: ";
            foreach (object ai in a) s += ai.ToString() + " ";
            Label7.Text = s;
        }

        protected void Button26_Click(object sender, EventArgs e)
        {
            SortedList<string, string> artysci = new SortedList<string, string>();
            artysci.Add("Sting", "Gordon Matthew Sumner");
            artysci.Add("Bolesław Prus", "Aleksander Głowacki");
            artysci.Add("Pola Negri", "Barbara Apolonia Chałupiec");
            artysci.Add("John Wayne", "Marion Michael Morrison");
            artysci.Add("Chico", "Leonard Marx");
            artysci.Add("Harpo", "Arthur Marx");
            artysci.Add("Groucho", "Julius Marx");
            artysci.Add("Bono", "Paul Hewson");
            artysci.Add("Ronaldo", "Luiz Nazario de Lima");
            artysci.Add("Madonna", "Madonna Louise Veronica Ciccone");
            artysci.Add("Gabriela Zapolska", "Maria G. Śnieżko-Błocka");

            string komunikat = "Zawartość listy:<br />";
            foreach (KeyValuePair<string, string> artysta in artysci)
                komunikat += artysta.Key + " - " + artysta.Value + "<br />";
            Label7.Text = komunikat;
        }

        protected void Button27_Click(object sender, EventArgs e)
        {
            int rozmiar = 10;
            Queue<int> kolejka = new Queue<int>(rozmiar);
            Stack<int> stos = new Stack<int>(rozmiar);
            for (int i = 0; i < rozmiar; ++i)
            {
                kolejka.Enqueue(i);
                stos.Push(i);
            }

            string s = "Elementy zdjęte z kolejki (" + kolejka.Count + " elementów): ";
            for (int i = 0; i < rozmiar; ++i) s += kolejka.Dequeue().ToString() + " ";
            s += "<br />Elementy zdjęte ze stosu (" + stos.Count + " elementów): ";
            for (int i = 0; i < rozmiar; ++i) s += stos.Pop().ToString() + " ";
            Label7.Text = s;
        }

        private int Suma(params int[] lista)
        {            
            Label7.Text += "<br />Liczba argumentów: " + lista.Length.ToString();
            int suma = 0;
            foreach (int liczba in lista) suma += liczba;            
            return suma;
        }

        protected void Button28_Click(object sender, EventArgs e)
        {
            int suma1 = Suma(new int[] { 1, 2, 3 });
            int suma = Suma(1, 2, 3);
            Label7.Text += "<br />Suma: " + suma.ToString();
        }

        /*
        int[] metoda(int rozmiar)
        {
            int[] wynik = new int[rozmiar];
            Random r = new Random();
            for (int i = 0; i < rozmiar; ++i)
            {
                wynik[i] = r.Next();
            }
            return wynik;
        }

        protected void Button29_Click(object sender, EventArgs e)
        {
            int[] ti = metoda(10);

            string s = "";
            foreach (int element in ti)
                s += element.ToString() + "<br />";
            Label7.Text = s;
        }
        */

        IEnumerable<int> metoda(int rozmiar)
        {
            Random r = new Random();
            for (int i = 0; i < rozmiar; ++i)
            {
                yield return r.Next();
            }
            yield break;
        }

        protected void Button29_Click(object sender, EventArgs e)
        {
            int[] ti = metoda(10).ToArray();

            string s = "";
            foreach (int element in ti)
                s += element.ToString() + "<br />";
            Label7.Text = s;
        }

        protected void Button30_Click(object sender, EventArgs e)
        {
            //obiekt
            Button b = new Button { Text = "Przycisk", BackColor=System.Drawing.Color.Green };
            //this.form1.Controls.Add(b);
            Panel2.Controls.Add(b);

            //tablica
            var it = new[] { 5, 4, 3, 2, 1, 0 };
            var lt = new[] { 5L, 4L, 3L, 2L, 1L, 0L };
            var st = new[] { "Helion", "Onepress", "Sensus", "Septem", "Editio" };
            var ft = new[] { 1.0f, 0.75f, 0.5f, 0.25f, 0.0f };
            var dt = new[] { 1.0, 0.75, 0.5, 0.25, 0.0 };

            //lista
            List<string> lista = new List<string> { "Helion", "Onepress", "Sensus", "Septem", "Editio" };
        }
        #endregion

        #region LINQ
        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu;
            public int Wiek;
        };

        //źródło danych
        List<Osoba> listaOsob = new List<Osoba> 
        { 
            new Osoba { Id = 1, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 7272024, Wiek = 39 }, 
            new Osoba { Id = 2, Imię = "Dawid", Nazwisko = "Borycki", NumerTelefonu = 7272020, Wiek = 29 },
            new Osoba { Id = 3, Imię = "Maciej", Nazwisko = "Pakulski", NumerTelefonu = 7272021, Wiek = 26 }, 
            new Osoba { Id = 4, Imię = "Maciej", Nazwisko = "Grabek", NumerTelefonu = 7272022, Wiek = 26 },
            new Osoba { Id = 5, Imię = "Adam", Nazwisko = "Kowalski", NumerTelefonu = 7272023, Wiek = 6 },
            new Osoba { Id = 6, Imię = "Ewa", Nazwisko = "Kowalska", NumerTelefonu = 7272025, Wiek = 11 }
        };

        protected void Button31_Click(object sender, EventArgs e)
        {
            //pobieranie danych (filtrowanie i sortowanie)
            var listaOsobPelnoletnich = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select osoba;

            List<Osoba> podlista = listaOsobPelnoletnich.ToList<Osoba>();

            //najprostsza prezentacja danych
            string s = "<b>Lista osób pełnoletnich:</b><br />";
            foreach (var osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "<br />";
            Label8.Text = s;

            //analiza danych
            Label8.Text += "<p>Wiek najstarszej osoby: " + listaOsobPelnoletnich.Max(osoba => osoba.Wiek);
            Label8.Text += "<br />Średni wiek osób pełnoletnich: " + listaOsobPelnoletnich.Average(osoba => osoba.Wiek);
            Label8.Text += "<br />Suma lat osób pełnoletnich: " + listaOsobPelnoletnich.Sum(osoba => osoba.Wiek);

            //wybór elementu
            var najstarszaOsoba = listaOsobPelnoletnich.Single(osoba1 => (osoba1.Wiek == listaOsobPelnoletnich.Max(osoba => osoba.Wiek)));
            Label8.Text += "<p>Najstarsza osoba: " + najstarszaOsoba.Imię + " " + najstarszaOsoba.Nazwisko + " (" + najstarszaOsoba.Wiek + ")";

            //weryfikowanie danych
            bool czyWszystkiePełnoletnie = listaOsobPelnoletnich.All(osoba => (osoba.Wiek > 18));
            bool czyZawieraPelnoletnią = listaOsob.Any(osoba => (osoba.Wiek > 18));

            //prezentacja w grupach
            var grupyOsobOTymSamymNazwisku = from osoba in listaOsob
                                             group osoba by osoba.Nazwisko into grupa
                                             select grupa;
            s = "<b>Lista osób pogrupowanych nazwiskami:</b><br />";
            foreach (var grupa in grupyOsobOTymSamymNazwisku)
            {
                s += "Grupa osób o nazwisku " + grupa.Key + "<br />";
                foreach (Osoba osoba in grupa) s += osoba.Imię + " " + osoba.Nazwisko + "<br />";
                s += "<br />";
            }
            Label8.Text += "<p>" + s;

            //łączenie zbiorów danych
            var listaOsobPelnoletnich1 = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
            var listaKobiet = from osoba in listaOsob
                              where osoba.Imię.EndsWith("a")
                              select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
            var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich1.Concat(listaKobiet);

            var listaPelnoletnich_I_Kobiet1 = listaOsobPelnoletnich1.Concat(listaKobiet).Distinct();
            var listaPelnoletnich_I_Kobiet2 = listaOsobPelnoletnich1.Union(listaKobiet);
            var listaKobietPelnoletnich = listaOsobPelnoletnich1.Intersect(listaKobiet);
            var listaPelnoletnichNiekobiet = listaOsobPelnoletnich1.Except(listaKobiet);

            //łączenie danych
            var listaTelefonów = from osoba in listaOsob
                                 select new { osoba.Id, osoba.NumerTelefonu };
            var listaPersonaliów = from osoba in listaOsob
                                   select new { osoba.Id, osoba.Imię, osoba.Nazwisko };

            var listaPersonaliówZTelefonami = from telefon in listaTelefonów
                                              join personalia in listaPersonaliów
                                              on telefon.Id equals personalia.Id
                                              select new
                                              {
                                                  telefon.Id,
                                                  personalia.Imię,
                                                  personalia.Nazwisko,
                                                  telefon.NumerTelefonu
                                              };
        }

        protected void Button32_Click(object sender, EventArgs e)
        {
            var listaOsobPelnoletnich = from osoba in listaOsob
                                        where osoba.Wiek >= 18
                                        orderby osoba.Wiek
                                        select osoba;

            var listaOsobPelnoletnich_kopie = from osoba in listaOsob
                                              where osoba.Wiek >= 18
                                              orderby osoba.Wiek
                                              select new Osoba
                                              {
                                                  Id = osoba.Id,
                                                  Imię = osoba.Imię,
                                                  Nazwisko = osoba.Nazwisko,
                                                  NumerTelefonu = osoba.NumerTelefonu,
                                                  Wiek = osoba.Wiek
                                              };

            Osoba pierwszyNaLiscie = listaOsobPelnoletnich.First<Osoba>();
            pierwszyNaLiscie.Imię = "Jan";
            pierwszyNaLiscie.Nazwisko = "Kowalski";
            pierwszyNaLiscie.Wiek = 24;

            string s = "<b>Lista osób pełnoletnich:</b><br />";
            foreach (var osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "<br />";
            Label8.Text = s;
        }
        #endregion
    }

    //klasa używana w części dotyczącej Metod (delegacje i zdarzenia)
    class Klasa
    {
        public delegate void Callback(object sender, DateTime czasZakonczeniaMetody);

        public Callback DelegacjaMetodaZakonczona;
        public event Callback ZdarzenieMetodaZakonczona;

        public void Metoda(Label label)
        {
            label.Text += "Metoda - początek<br />";

            //tu długie działanie metody

            label.Text += "Metoda - tuż przed końcem<br />";

            if (ZdarzenieMetodaZakonczona != null) ZdarzenieMetodaZakonczona(this, DateTime.Now);
            if (DelegacjaMetodaZakonczona != null) DelegacjaMetodaZakonczona(this, DateTime.Now);

            label.Text += "Metoda - koniec<br />";
        }
    }
}