﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Security;
using System.Data;

public partial class Default2 : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!User.Identity.IsAuthenticated)
            Response.Redirect("~/Default.aspx");
        if (!IsPostBack)
        {
            txtEmail.Text = Membership.GetUser(User.Identity.Name).Email;
            DataView dv = SqlDataSourceZmienProfil.Select(DataSourceSelectArguments.Empty) as DataView;
            if (dv.Table.Rows.Count > 0)
                txtTelefon.Text = dv.Table.Rows[0]["Telefon"].ToString();
        }
    }
    protected void btnZmien_Click(object sender, EventArgs e)
    {
        MembershipUser mu = Membership.GetUser(User.Identity.Name);
        mu.Email = txtEmail.Text;
        Membership.UpdateUser(mu);
        SqlDataSourceZmienProfil.Update();
    }
    protected void SqlDataSourceZmienProfil_Selecting(object sender, SqlDataSourceSelectingEventArgs e)
    {
        e.Command.Parameters["@UserID"].Value = User.Identity.Name;
    }
    protected void SqlDataSourceZmienProfil_Updating(object sender, SqlDataSourceCommandEventArgs e)
    {
        e.Command.Parameters["@UserID"].Value = User.Identity.Name;
    }
}
