using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Data.OleDb;
using System.Data.Common;

public partial class DataEditor : System.Web.UI.Page
{
   OleDbConnection _conn = null;

    /// <summary>
    /// Procedura obsugi adowania strony
    /// </summary>
    protected void Page_Load(object sender, EventArgs e)
    {
      if (!IsPostBack)
      {
         LoadAllBooks();
         panBook.Visible = false;
      }
    }

    /// <summary>
    /// Doczanie danych do listy rozwijanej z ksikami
    /// </summary>
    private void LoadAllBooks()
    {
      OleDbDataReader reader = GetReader(GetBookSql(),null,true);
      lboxBooks.DataSource = reader;
      lboxBooks.DataBind();
      reader.Close();
    }

    /// <summary>
    /// Zwraca cig SQL z wybranymi informacjami o ksice
    /// </summary>
    private string GetBookSql()
    {
      return "SELECT ISBN,Title,YearPublished,PublisherId FROM Books";
    }

/// <summary>
/// Obsuga wyboru ksiki
/// </summary>
protected void SelectBooks(object sender, EventArgs e)
{
   // pokazanie panelu
   panBook.Visible = true;

   // odczytanie numeru isbn ksiki wybranej przez uytkownika
   string sId = lboxBooks.SelectedValue;

   // tworzenie zapytania sql dla wybranego numeru isbn
   string sql = GetBookSql();
   sql += " WHERE ISBN=@Id";

   // utworzenie parametrw zapytania
   OleDbParameter[] param = {
      new OleDbParameter("@ID", sId)
   };

   // pobranie obiektu odczytu danych zawierajcych dane ksiki
   OleDbDataReader reader = GetReader(sql, param, true);
   
   try
   {
      // jeeli mamy obiekt odczytu, to kontynuujemy
      if (reader != null)
      {
         // ustawienie kursora na pierwszym rekordzie
         if (reader.Read())
         {
            // pobranie kolumny danych z obiektu
            // korzystajc z nazw pl lub numerw
            // i przypisanie ich do pl formularza
            txtIsbn.Text = (string)reader["ISBN"];

            if (!reader.IsDBNull(1))
               txtTitle.Text = reader.GetString(1);
            else
               txtTitle.Text = "";

            if (!reader.IsDBNull(2))
               txtYear.Text = reader.GetInt32(2).ToString();
            else
               txtYear.Text = "";

            // identyfikator wydawcy jest nieco bardziej skomplikowany, 
             // poniewa mamy warto w licie rozwijanej
            int publisherId = reader.GetInt32(3);
            MakePublisherDropDown(publisherId);

            labUpdate.Text = "";
         }
      }
   }
   catch (Exception ex)
   {
      labMsg.Text = "[lboxBooks_SelectedIndexChanged] ";
      labMsg.Text += "Wystpi bd podczas dostpu do bazy danych";
      labMsg.Text += "<br/>" + ex.Message;
   }
   finally
   {
      reader.Close();
   }
}

    /// <summary>
    /// Doczanie danych do listy wydawcw,
    /// a nastpnie zaznaczenie elementu listy na podstawie 
    /// przekazanej wartoci publisherId 
    /// </summary>
    private void MakePublisherDropDown(int publisherId)
    {
      string sql = "SELECT PublisherId, PublisherName ";
      sql += " FROM Publishers ORDER BY PublisherName";

      OleDbDataReader reader = GetReader(sql, null, false);
      drpPublisher.DataSource = reader;
      drpPublisher.DataBind();

      // uycie przekazanej wartoci publisherId do zaznaczenia elementu listy
      drpPublisher.SelectedValue = publisherId.ToString();
      reader.Close();
    }

    /// <summary>
    /// Procedura obsugi aktualizacji danych ksiaki 
    /// </summary>
    protected void UpdateBook(object sender, EventArgs e)
    {
      // odczytanie numeru isbn ksiki wybranej przez uytkownika
      string sId = lboxBooks.SelectedValue;

      // tworzenie sql dla podanego numeru isbn
      string sql = "UPDATE Books SET Title=@title, YearPublished=@yearPub, PublisherId=@pubId";
      sql += " WHERE ISBN=@isbn";
      labUpdate.Text = sql;

      // pobranie poczenia do bazy danych
      OleDbConnection conn = GetConnection();

      try
      {
        // utworzenie obiektu polecenia
        OleDbCommand cmd = new OleDbCommand(sql, conn);

        // dodanie parametrw
        cmd.Parameters.Add(new OleDbParameter("@title", txtTitle.Text));
        cmd.Parameters.Add(new OleDbParameter("@yearPub", txtYear.Text));
        // mona rwnie uy metody AddWithValue jako alternatywy dla powyszych
        cmd.Parameters.AddWithValue("@pubId", drpPublisher.SelectedValue);
        cmd.Parameters.AddWithValue("@isbn", txtIsbn.Text);

        // wykonanie polecenia 
        cmd.ExecuteNonQuery();

        labUpdate.Text = "Udana aktualizacja rekordu";
      }
      catch (Exception ex)
      {
        labMsg.Text = "[btnUpdate_Click] ";
        labMsg.Text += "Podczas dostpu do bazy danych wystpi bd";
        labMsg.Text += "<br/>" + ex.Message;
      }
      finally
      {
        conn.Close();
        conn = null;
      }
    }

    /// <summary>
    /// Pobiera obiekt odczytu danych dla przekazanego cigu SQL
    /// </summary>
    /// <param name="sql">Zawiera instrukcj SQL polecenia</param>
    /// <param name="param">Opcjonalne parametry dodawane do polecenia</param>
    /// <param name="addClose">jeeli ma warto truem zamyka obiekt odczytu</param>
    /// <returns>obiekt odczytu danych zawierajcy dane dane SQL</returns>
    private OleDbDataReader GetReader(string sql, OleDbParameter[] parameters, bool addClose)
    {
     // pobranie poczenia do bazy danych
     OleDbConnection conn = GetConnection();
     OleDbDataReader reader = null;
     try
     {
       // tworzenie obiektu poczenia dla przekazanego SQL
       OleDbCommand cmd = new OleDbCommand(sql, conn);

       // dodanie parametrw, jeeli zostay przekazane
       if (parameters != null)
       {
         foreach (OleDbParameter param in parameters)
           cmd.Parameters.Add(param);
       }

       // ComandBehavior.CloseConnection wskazuje, e 
       // poczenie zostanie zamknite po zakoczeniu odczytu danych
       if (addClose)
         reader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
       else
         reader = cmd.ExecuteReader();
     }
     catch (Exception ex)
     {
       labMsg.Text = "[GetReader] Wystpi bd w czasie dostpu do bazy danych";
       labMsg.Text += "<br/>" + ex.Message;

       if (reader != null)
         reader.Close();
       if (conn != null)
         conn.Close();
     }

     // Zwracanie wynikowego obiektu odczytu.
     return reader;
    }

    /// <summary>
    /// Zwraca obiekt poczenia do bazy danych
    /// </summary>
    /// <returns></returns>
    private OleDbConnection GetConnection()
    {
      // jeeli dane skadowe maj warto null, to znaczy e
      // poczenie nie zostao utworzone ani otwarte
      if (_conn == null || _conn.State == ConnectionState.Closed)
      {
         // odczytanie cigu poczenia do bazy danych, zmieni w razie potrzeby
         string connString = ConfigurationManager.ConnectionStrings["Books"].ConnectionString;

         try
         {
            // pobranie poczenia do bazy danych
            _conn = new OleDbConnection(connString);

            // otwarcie poczenia
            _conn.Open();
         }
         catch (Exception ex)
         {
            labMsg.Text = "[GetConnection] Wystpi bd w czasie dostpu do bazy danyych";
            labMsg.Text += "<br/>" + ex.Message;
            if (_conn != null)
               _conn.Close();
         }
      }
      return _conn;
    }
}
