using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class SettingRelations : System.Web.UI.Page
{
   DataSet ds = null;

   protected void Page_Load(object sender, EventArgs e)
   {
      ds = new DataSet();

      ds.Tables.Add(MakeAuthorData());
      ds.Tables.Add(MakeBookData());

      DataRelation relation = new DataRelation("Book2Author", ds.Tables["Authors"].Columns["AuthorId"], ds.Tables["Books"].Columns["AuthorId"]);
      ds.Relations.Add(relation);

      grdAuthors.DataSource = ds.Tables["Authors"].DefaultView;
      grdAuthors.DataBind();

      grdBooks.DataSource = ds.Tables["Books"].DefaultView;
      grdBooks.DataBind();

foreach (DataRow artistRow in ds.Tables["Authors"].Rows)
{
   string fname = (string)artistRow["FirstName"];
   string lname = (string)artistRow["LastName"];
   labReport.Text += "<dt>" + fname + " " + lname;

   foreach (DataRow bookRow in artistRow.GetChildRows(relation))
   {
      string title = (string)bookRow["Title"];
      labReport.Text += "<dd>" + title;
   }         
}
   }

   /// <summary>
   /// Creates and returns a populated DataTable
   /// </summary>
   private DataTable MakeAuthorData()
   {
      DataTable table = new DataTable();
      table.TableName = "Authors";

      DataColumn idCol = new DataColumn();
      idCol.ColumnName = "AuthorId";
      idCol.DataType = typeof(Int32);
      idCol.AllowDBNull = false;
      idCol.Unique = true;

      DataColumn firstNameCol = new DataColumn("FirstName", typeof(string));
      DataColumn lastNameCol = new DataColumn("LastName", typeof(string));

      table.Columns.Add(idCol);
      table.Columns.Add(firstNameCol);
      table.Columns.Add(lastNameCol);

      DataRow r1 = table.NewRow();
      r1[0] = 10;
      r1[1] = "Thomas";
      r1[2] = "Hobbes";
      table.Rows.Add(r1);

      DataRow r2 = table.NewRow();
      r2[0] = 20;
      r2["FirstName"] = "David";
      r2["LastName"] = "Hume";
      table.Rows.Add(r2);

      DataRow r3 = table.NewRow();
      r3[0] = 30;
      r3["FirstName"] = "Martin";
      r3["LastName"] = "Heidegger";
      table.Rows.Add(r3);

      DataRow r4 = table.NewRow();
      r4[0] = 40;
      r4["FirstName"] = "Jean-Jacques";
      r4["LastName"] = "Rosseau";
      table.Rows.Add(r4);

      return table;
   }

   /// <summary>
   /// Creates and returns a populated DataTable
   /// </summary>
   private DataTable MakeBookData()
   {
      DataTable table = new DataTable();
      table.TableName = "Books";

      DataColumn idCol = new DataColumn();
      idCol.ColumnName = "Id";
      idCol.DataType = typeof(Int32);
      idCol.AllowDBNull = false;
      idCol.Unique = true;
      idCol.AutoIncrement = true;

      DataColumn authorCol = new DataColumn("AuthorId", typeof(Int32));
      DataColumn nameCol = new DataColumn("Title", typeof(string));
      DataColumn priceCol = new DataColumn("Price", typeof(double));

      table.Columns.Add(idCol);
      table.Columns.Add(authorCol);
      table.Columns.Add(nameCol);
      table.Columns.Add(priceCol);

      DataRow r1 = table.NewRow();
      r1[1] = 30;
      r1[2] = "The Theory of Communicative Action";
      r1[3] = 49.99;
      table.Rows.Add(r1);

      DataRow r2 = table.NewRow();
      r2[1] = 10;
      r2[2] = "Leviathan";
      r2[3] = 19.99;
      table.Rows.Add(r2);

      DataRow r3 = table.NewRow();
      r3[1] = 40;
      r3[2] = "Emile";
      r3[3] = 24.99;
      table.Rows.Add(r3);

      DataRow r4 = table.NewRow();
      r4[1] = 40;
      r4[2] = "The Social Contract";
      r4[3] = 24.99;
      table.Rows.Add(r4);

      return table;
   }
}
