using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class PizzaPanelTest : System.Web.UI.Page
{
    // dane skadowe wykorzystywane w formularzu
    private decimal pizzaBase = 0.0M;
    private decimal pizzaToppings = 0.0M;

    /// <summary>
    /// wywoywana przy kadym zaadowaniu strony i przesaniu danych
    /// </summary>
    protected void Page_Load(object sender, EventArgs e)
    {
        // inicjalizacja widocznoci kontrolek i paneli
        txtAddress.Visible = false;
        labAddress.Visible = false;

        panPricing.Visible = false;
        panOrder.Visible = false;


        if (IsPostBack)
        {
            // jeeli zaznaczone jest pole dostawy to naley wywietli adres
            // Uwaga: tutaj wykonujemy t operacj bez uycia paneli
            if (IsDelivery())
            {
                this.labAddress.Visible = true;
                this.txtAddress.Visible = true;
            }
            // jeeli zostanie wybrany odpowiedni rozmiar, wywietlany jest panel
            // ze znajdujc si w nim tabel cen
            if (IsValidSize())
            {
                this.panPricing.Visible = true;
                GeneratePricing();
            }
        }
    }

    /// <summary>
    /// Czy wybrano dostaw pizzy?
    /// </summary>
    /// <returns></returns>
    private bool IsDelivery()
    {
        if (this.chkDelivery.Checked)
            return true;
        else
            return false;
    }

    /// <summary>
    /// Obliczenie ceny na podstawie wielkoci
    /// </summary>
    private void CalculatePrices()
    {

        // obliczenie ceny na podstawie rozmiaru
        if (this.drpSize.SelectedValue == "M")
            pizzaBase = 10.0M;
        else if (this.drpSize.SelectedValue == "S")
            pizzaBase = 15.0M;
        else if (this.drpSize.SelectedValue == "D")
            pizzaBase = 20.0M;

        // dodanie 1,50 za kady dodatek
        foreach (ListItem item in this.clstToppings.Items)
        {
            if (item.Selected)
                pizzaToppings += 1.50M;
        }
    }

    /// <summary>
    /// Czy wybrano prawidowy rozmiar pizzy?
    /// </summary>
    /// <returns></returns>
    private bool IsValidSize()
    {
        if (this.drpSize.SelectedValue != "W")
            return true;
        else
            return false;
    }

    /// <summary>
    /// Generowanie tabeli cen
    /// </summary>
    private void GeneratePricing()
    {
      litPricing.Text = "<dl>";
        CalculatePrices();

      litPricing.Text += CreatePricingRow("Cena podstawowa", pizzaBase, false);
      litPricing.Text += CreatePricingRow("Dodatki", pizzaToppings, false);
        decimal delivCharge = 0.0M;
        if (IsDelivery())
        {
            delivCharge = 1.00M;
         litPricing.Text += CreatePricingRow("Dostawa", delivCharge, false);
        }
        decimal subtotal = pizzaBase + pizzaToppings + delivCharge;
        decimal tax = subtotal * 0.07M;
      litPricing.Text += CreatePricingRow("VAT", tax, false);
        decimal total = subtotal + tax;
      litPricing.Text += CreatePricingRow("Razem", total, true);
    }

    /// <summary>
    /// Tworzenie wiersza tabeli cen
    /// </summary>
    private string CreatePricingRow(string label, decimal value, bool isBold)
    {
      string s = "<dt id='item'>" + label + "</dt>";
      s += "<dd id='price'>";
      if (isBold) s += "<strong>";
      s += String.Format("{0:c}",value);
      if (isBold) s += "</strong>";
      s += "</dd>";
        return s;
    }

    /// <summary>
    /// Wywoywana po klikniciu przycisku zamwienia
    /// </summary>
    protected void btnOrder_Click(object sender, EventArgs e)
    {
        // Tworzenie podsumowania zamwienia
        String s = "<b>Wielko zamwionej pizzy: " + drpSize.SelectedItem.Text + "</b><br/>";
        s += "Dla " + this.txtCustomer.Text + "<br>";
        if (IsDelivery())
            s += "Dostawa do " + this.txtAddress.Text + "<br>";
        s += rlstCrust.SelectedItem.Text + " ciasto<br>";
        s += "<b>Dodatki:</b><br>";
        foreach (ListItem item in this.clstToppings.Items)
        {
            if (item.Selected)
                s += item.Text + "<br>";
        }

        // wywietlenie panelu podsumowania zamwienia oraz zawartoci
        panOrder.Visible = true;
        labOrder.Text = s;
    }
}
