﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="CustomWizard.aspx.cs" Inherits="CustomWizard" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
   <title>Custom Wizard</title>
   <link href="chapterStyles.css" type="text/css" rel="stylesheet" />
   <style type="text/css">
    .wizardStepContent { padding: 5px; }
    .wizardNavContent { padding: 4px; }
    </style>
</head>
<body>
   <form id="form1" runat="server">
   <asp:Wizard ID="myWizard" runat="server" 
      HeaderText="Checkout" BackColor="#CCCC99"
      BorderColor="#999999" BorderWidth="1px" 
      Height="200" OnActiveStepChanged="myWizard_ActiveStepChanged" 
      OnNextButtonClick="myWizard_NextButtonClick"
      OnFinishButtonClick="myWizard_FinishButtonClick" 
      OnPreviousButtonClick="myWizard_PreviousButtonClick"
      OnSideBarButtonClick="myWizard_SideBarButtonClick">
      
      <HeaderStyle BackColor="#FFFFFF" Font-Size="Medium" VerticalAlign="Top" />
      <HeaderTemplate>
         <div style="margin: 5px 5px 5px 5px">
         <img src='images/title_checkout_step<%= myWizard.ActiveStepIndex+1 %>.gif' 
           alt='Checkout <%= myWizard.ActiveStep.Title%>' />
         </div>
      </HeaderTemplate>
      <SideBarStyle VerticalAlign="Top" BackColor="#FFFFCC" Font-Size="small" />
      
      <SideBarTemplate>
         <asp:Panel Style="padding: 10px 10px 10px 10px" 
            ID="panSide" runat="server">
            <asp:DataList ID="SideBarList" runat="server">
               <ItemTemplate>
                  <asp:ImageButton ID="SideBarButton" runat="server" 
                  CommandName="MoveTo" 
                  ImageUrl='<%# GetStepImage((string)Eval("Title"))%>' />
               </ItemTemplate>
               <SelectedItemTemplate>
                  <asp:ImageButton ID="SideBarButton" runat="server" 
                  CommandName="MoveTo" 
                  ImageUrl='<%# GetSelectedStepImage((string)Eval("Title"))%>' />
               </SelectedItemTemplate>
            </asp:DataList>
         </asp:Panel>
      </SideBarTemplate>
      
      <StepStyle CssClass="wizardStepContent" VerticalAlign="Top" />
      <NavigationStyle BackColor="white" VerticalAlign="Bottom" />
      <NavigationButtonStyle BackColor="#FFFFCC" ForeColor="#666633" />
      
      <StartNavigationTemplate>
         <asp:Panel ID="panStart" runat="server" CssClass="wizardNavContent">
            <asp:ImageButton runat="server" ID="imgStart" 
               ImageUrl="~/images/button_checkout_start.gif"
               CommandName="MoveNext" AlternateText="Sign-In" />
         </asp:Panel>
      </StartNavigationTemplate>
      
      <StepNavigationTemplate>
         <asp:Panel ID="panStep" runat="server" CssClass="wizardNavContent">
            <asp:ImageButton runat="server" ID="imgPrev" 
               ImageUrl="~/images/button_checkout_previous.gif"
               CommandName="MovePrevious" AlternateText="Previous" />
            <asp:ImageButton runat="server" ID="imgNext" 
               ImageUrl="~/images/button_checkout_next.gif"
               CommandName="MoveNext" AlternateText="Next" />
         </asp:Panel>
      </StepNavigationTemplate>
      
      <FinishNavigationTemplate>
         <asp:Panel ID="panFinish" runat="server" CssClass="wizardNavContent">
            <asp:ImageButton runat="server" ID="imgPrev" 
               ImageUrl="~/images/button_checkout_previous.gif"
               CommandName="MovePrevious" AlternateText="Previous" />
            <asp:ImageButton runat="server" ID="imgPayment" 
               ImageUrl="~/images/button_checkout_finish.gif"
               CommandName="MoveComplete" AlternateText="Make Payment" />
         </asp:Panel>
      </FinishNavigationTemplate>
      
      <WizardSteps>
         <asp:WizardStep ID="WizardStep1" runat="server" 
            Title="Login" StepType="Start">
            Email<br />
            <asp:TextBox ID="txtEmail" runat="server" /><br />
            Password<br />
            <asp:TextBox ID="txtPassword" runat="server" TextMode="Password" />
         </asp:WizardStep>
         
         <asp:WizardStep ID="WizardStep2" runat="server" Title="Address">
            Address Line 1:
            <br />
            <asp:TextBox runat="server" ID="txtAddress1" Width="314px" />
            <br />
            Address Line 2:
            <br />
            <asp:TextBox runat="server" ID="txtAddress2" Width="314px" />
            <br />
            City:
            <br />
            <asp:TextBox runat="server" ID="txtCity" Width="155px" />
            <br />
            State:
            <br />
            <asp:TextBox runat="server" ID="txtState" Width="75px" />
            <br />
            ZIP/Postal Code:
            <br />
            <asp:TextBox runat="server" ID="txtZip" Width="50px" />
         </asp:WizardStep>
         
         <asp:WizardStep ID="WizardStep3" runat="server" Title="Shipping">
            Shipper<br />
            <asp:DropDownList ID="drpShipper" runat="server">
               <asp:ListItem>Air Mail</asp:ListItem>
               <asp:ListItem>Xpresspost</asp:ListItem>
               <asp:ListItem>Fed Ex</asp:ListItem>
            </asp:DropDownList>
         </asp:WizardStep>
         <asp:WizardStep ID="WizardStep4" runat="server" 
            Title="Payment" StepType="Finish"
            AllowReturn="false">
            Payment Type<br />
            <asp:DropDownList ID="drpPayment" runat="server">
               <asp:ListItem>American Express</asp:ListItem>
               <asp:ListItem>Visa</asp:ListItem>
               <asp:ListItem>Mastercard</asp:ListItem>
            </asp:DropDownList>
            <br />
            Expiry Month:
            <br />
            <asp:DropDownList ID="drpMonth" runat="server">
               <asp:ListItem>01</asp:ListItem>
               <asp:ListItem>02</asp:ListItem>
               <asp:ListItem>03</asp:ListItem>
               <asp:ListItem>04</asp:ListItem>
               <asp:ListItem>05</asp:ListItem>
               <asp:ListItem>06</asp:ListItem>
               <asp:ListItem>07</asp:ListItem>
               <asp:ListItem>08</asp:ListItem>
               <asp:ListItem>09</asp:ListItem>
               <asp:ListItem>10</asp:ListItem>
               <asp:ListItem>11</asp:ListItem>
               <asp:ListItem>12</asp:ListItem>
            </asp:DropDownList>
            <br />
            Expiry Year:
            <br />
            <asp:DropDownList ID="drpYear" runat="server">
               <asp:ListItem>2005</asp:ListItem>
               <asp:ListItem>2006</asp:ListItem>
               <asp:ListItem>2007</asp:ListItem>
               <asp:ListItem>2008</asp:ListItem>
               <asp:ListItem>2009</asp:ListItem>
               <asp:ListItem>2010</asp:ListItem>
            </asp:DropDownList>
            <br />
         </asp:WizardStep>
         
         <asp:WizardStep ID="WizardStep5" runat="server" Title="Confirmation" StepType="Complete">
            <asp:Label ID="labConfirmation" runat="server"></asp:Label>
         </asp:WizardStep>
      </WizardSteps>
   </asp:Wizard>
   <asp:Label ID="myLabel" runat="server"></asp:Label>
   </form>
</body>
</html>
