﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="CheckAndRadioLists.aspx.cs"
    Inherits="CheckAndRadioLists" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Demonstracja kontrolek CheckBoxList i RadioButtonList</title>
    <link href="chapterStyles.css" type="text/css" rel="stylesheet" />
    <style type="text/css">
    .layout {
        border: 1px; 
        background-color: LightGrey; 
        border-color: Gray; 
        padding: 5px 5px 5px 5px;
        width: 50%;
    }
    </style>
</head>
<body>
   <form id="form1" runat="server">
   <div id="container">
      <h1>Demonstracja kontrolek CheckBoxList i RadioButtonList</h1>
      <div class="layout">
          Kierunek powtarzania:
          <asp:DropDownList ID="drpDirection" runat="server">
              <asp:ListItem>Horizontal</asp:ListItem>
              <asp:ListItem Selected="True">Vertical</asp:ListItem>
          </asp:DropDownList><br />
          Układ powtarzania:
          <asp:DropDownList ID="drpLayout" runat="server">
              <asp:ListItem Selected="True">Table</asp:ListItem>
              <asp:ListItem>Flow</asp:ListItem>
          </asp:DropDownList><br />
          Kolumny powtarzania:
          <asp:DropDownList ID="drpColumns" runat="server">
              <asp:ListItem>1</asp:ListItem>
              <asp:ListItem>2</asp:ListItem>
              <asp:ListItem>3</asp:ListItem>
          </asp:DropDownList>
          <br />
          <asp:Button ID="btnChange" runat="server" Text="Zmień właściwości" OnClick="btnChange_Click" />
      </div>
      <div class="box">
      <p>
          Ciasto:
          <br>
          <asp:RadioButtonList ID="rlstCrust" runat="server" >
              <asp:ListItem>Cienkie</asp:ListItem>
              <asp:ListItem>Średnie</asp:ListItem>
              <asp:ListItem Selected="True">Grube</asp:ListItem>
          </asp:RadioButtonList></p>
      <p>
          Dodatki:<br>
          <asp:CheckBoxList ID="clstToppings" runat="server" 
              RepeatDirection="Vertical" RepeatLayout="Table" RepeatColumns="2">
              <asp:ListItem>Szynka</asp:ListItem>
              <asp:ListItem>Pieczarki</asp:ListItem>
              <asp:ListItem>Pepperoni</asp:ListItem>
              <asp:ListItem>Pomidory</asp:ListItem>
              <asp:ListItem>Zielony pieprz</asp:ListItem>
              <asp:ListItem>Krewetki</asp:ListItem>
              <asp:ListItem>Dodatkowy ser</asp:ListItem>
              <asp:ListItem>Anchovie</asp:ListItem>
          </asp:CheckBoxList></p>
   
      <asp:Button ID="btnOrder" runat="server" Text="Zamów" OnClick="btnOrder_Click" />
     
      </div>
      <p><asp:Label ID="labMessage" runat="server"></asp:Label></p>
   </div>
   </form>
</body>
</html>
