using System;
using System.Data;
using System.Data.Common;
using System.Collections.Generic;

using FourLayer.BusinessEntity;

namespace FourLayer.DataAccessObject
{

   /// <summary>
   /// Summary description for PublisherDAO
   /// </summary>
   public class SeriesDAO : AbstractDAO<Series>
   {
      public SeriesDAO()
      {
      }

      protected override string SelectStatement
      {
         get { return "SELECT SeriesId, SeriesName FROM Series"; }
      }
      protected override string PrimaryKeyName
      {
         get { return "SeriesId"; }
      }
      public override bool IsGetAllCached
      {
         get { return true; }
      }
      public override string CacheName
      {
         get { return "Series"; }
      }

      protected override Series CreateAndFillEntity(DbDataReader recordJustRead)
      {
         // grab the record values and put them into temporary variables
         int id = recordJustRead.GetInt32(0);
         string name = recordJustRead.GetString(1);

         // build and populate object from the data
         Series series = new Series(id, name);
         return series;
      }

      public override DataTable AdaptCollectionToDataTable(EntityCollection<Series> collection)
      {
         DataTable dt = new DataTable();
         dt.Columns.Add(new DataColumn("Id", Type.GetType("System.Int32")));
         dt.Columns.Add(new DataColumn("Name", Type.GetType("System.String")));

         foreach (Series s in collection)
         {
            DataRow dr = dt.NewRow();
            dr[0] = s.Id;
            dr[1] = s.Name;
            dt.Rows.Add(dr);
         }
         return dt;
      }


      public override void Update(Series series)
      {
         string sql = "UPDATE Series SET SeriesName=@SeriesName";
         sql += " WHERE SeriesId=@SeriesId";

         // construct array of parameters
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@SeriesId", series.Id, DbType.Int32),
            DatabaseActions.MakeParameter("@SeriesName", series.Name, DbType.String)
			};

         // run the specified command
         DatabaseActions.RunNonQuery(sql, parameters);
      }

      public override void Insert(Series series)
      {
         string sql = "INSERT INTO Series (SeriesName) ";
         sql += " VALUES (@SeriesName)";

         // construct array of parameters
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@SeriesName", series.Name, DbType.String)
			};

         // run the specified command
         DatabaseActions.RunNonQuery(sql, parameters);
      }

      public override void Delete(Series series)
      {
         string sql = "DELETE FROM Series WHERE SeriesId=@SeriesId";

         // construct array of parameters
         DbParameter[] parameters = new DbParameter[] {
            DatabaseActions.MakeParameter("@SeriesId", series.Id, DbType.Int32)
			};

         // run the specified command
         DatabaseActions.RunNonQuery(sql, parameters);
      }
   }
}