using System;
using System.Data;
using System.Data.Common;

namespace TwoLayer.DataAccess
{
   /// <summary>
   /// 
   /// </summary>
   public class SeriesDA : AbstractDA
   {

      protected override string SelectStatement
      {
         get { return "SELECT SeriesId, SeriesName FROM Series"; }
      }

      /// <summary>
      /// Zwraca tabel z danymi zawierajc informacje o tabeli wydawcy dla okrelonego identyfikatora.
      /// Ten zbir danych bdzie zawiera 0 lub 1 wiersz danych.
      /// </summary>
      public override DataTable GetById(object oId)
      {
         int id = (int)oId;

         // utwrz sparametryzowan instrukcj zapytania
         string sql = SelectStatement + " WHERE SeriesId=@id";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
			MakeParameter("@id", id, DbType.Int32)
															};
         // zwr wynik
         return GetDataTable(sql, parameters);
      }

   }
}
