using System;
using System.Data;
using System.Configuration;

using System.Collections.Generic;
using System.Collections.ObjectModel;

using TwoLayer.DataAccess;

namespace ThreeLayer.Business
{
   /// <summary>
   /// Oglny opis PublisherCollectionBO
   /// </summary>
   public class PublisherCollectionBO
   {
      private List<PublisherBO> _list;

      public PublisherCollectionBO()
      {
         _list = new List<PublisherBO>();
         Load();
      }

      public void Add(PublisherBO publisher)
      {
         if (publisher != null)
            _list.Add(publisher);
      }

      public PublisherBO Get(int id)
      {
         foreach (PublisherBO pub in _list)
         {
            if (pub.Id == id)
               return pub;
         }
         return null;
      }

      public void Load()
      {
         PublisherDA da = new PublisherDA();
         DataTable dt = da.GetAll();

         foreach (DataRow dr in dt.Rows)
         {
            int id = (int)dr["PublisherId"];
            string name = (string)dr["PublisherName"];
            PublisherBO pub = new PublisherBO(id, name);
            Add(pub);
         }
      }

      public ReadOnlyCollection<PublisherBO> ReadOnlyCopy()
      {
         return _list.AsReadOnly();
      }

   }
}