using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class FooterCalculation : System.Web.UI.Page
{
   int _count = 0;
   decimal _sumPrice = 0.0M;
   decimal _sumCost = 0.0M;
   
   protected void grdSample_RowDataBound(object sender, GridViewRowEventArgs e)
   {

      // Sprawdza, czy jest to wiersz z danymi. Nie jest to konieczne, ale
      // w kadym razie stanowi dobr praktyk
      if (e.Row.RowType == DataControlRowType.DataRow)
      {
         // pobierz cen
         decimal price = (decimal)DataBinder.Eval(e.Row.DataItem, "Price");
         decimal cost = (decimal)DataBinder.Eval(e.Row.DataItem, "Cost");

         _sumPrice += price;
         _sumCost += cost;
         _count++;
      }
      else if (e.Row.RowType == DataControlRowType.Footer)
      {
         e.Row.Cells[0].Text = "Liczba prac: ";
         e.Row.Cells[0].Text += _count;

         e.Row.Cells[1].Text = "rednia<br/>";
         decimal avgPrice = _sumPrice / _count;
         e.Row.Cells[1].Text += String.Format("{0:c}", avgPrice);

         e.Row.Cells[2].Text = "rednia<br/>";
         decimal avgCost = _sumCost / _count;
         e.Row.Cells[2].Text += String.Format("{0:c}", avgCost);

      }
    
   }
   protected void grdSample_DataBound(object sender, EventArgs e)
   {
      /*
      int count = 0;
      decimal sumPrice = 0.0M;
      decimal sumCost = 0.0M;

      // przejd przez kady wiersz
      foreach (GridViewRow row in grdSample.Rows)
      {
         // pobierz cen
         decimal price = Decimal.Parse(row.Cells[1].Text);
         decimal cost = Decimal.Parse(row.Cells[2].Text);

         sumPrice += price;
         sumCost += cost;
         count++;
      }

      GridViewRow footer = grdSample.FooterRow;

      footer.Cells[0].Text = "Liczba prac: ";
      footer.Cells[0].Text += count;

      footer.Cells[1].Text = "rednia<br/>";
      footer.Cells[1].Text += String.Format("{0:c}", sumPrice / count);

      footer.Cells[2].Text = "rednia<br/>";
      footer.Cells[2].Text += String.Format("{0:c}", sumCost / count);
       * */
   }
}
