<%@ Page Language="C#" AutoEventWireup="true" CodeFile="EditFormView.aspx.cs" Inherits="EditFormView" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
	<title>Edycja w kontrolce FormView</title>
	<link href="chapterStyles.css" type="text/css" rel="stylesheet" />
	<style type="text/css">
		.dataValues { font-weight: bold; }
		.singleBook { border-top: 1pt solid #E7E7E7;
		              border-left: 1pt solid #E7E7E7;
		              border-bottom: 1pt solid #D2D2D2;
		              border-right: 1pt solid #D2D2D2;
		              padding: 1em;	
		              margin: 1em;              
		              background: #FFFFE0;		              
		               }
		 .singleBookTitle {
                    vertical-align: middle;
                    text-align: center;
		              background: #FFFFCC;
		              }
		  .entireForm {
		            border: 2pt solid #D7D7D7; 
		  }
		  .actionBar { background: #FFFFCC; margin-top: 0.5em; padding: 0.5em; border: 1pt solid #E7E7E7;}
	</style>
</head>
<body>
	<form id="form1" runat="server">
		<div id="container">
      <h1>Edycja w kontrolce FormView</h1>
      <p>
      Przykad pokazuje, jak umoliwi edycj danych w kontrolce <code>FormView</code>.
      </p>
      <asp:FormView ID="frmvBooks" runat="server" DataSourceID="dsBooks" 
            CssClass="entireForm" AllowPaging="true" DataKeyNames="Isbn">
         <HeaderTemplate>
            <h2>Informacje o ksice</h2>
         </HeaderTemplate>
         <HeaderStyle CssClass="singleBookTitle" />
         <ItemTemplate>
            <div class="singleBook">
            ISBN: <br />
            <asp:Label ID="labIsbn" runat="server"
              Text='<%# Eval("ISBN") %>' CssClass="dataValues" /><br />
            Tytu:<br />
            <asp:Label ID="labTitle" runat="server"
              Text='<%# Eval("Title") %>' CssClass="dataValues" /><br />
            Wydawca:<br />
            <asp:Label ID="labPublisher" runat="server"
              Text='<%# Eval("PublisherName") %>' CssClass="dataValues" /><br />
            Rok:<br />
            <asp:Label ID="labYear" runat="server"
              Text='<%# Eval("YearPublished") %>' CssClass="dataValues" /><br />
            Opis:<br />
            <asp:Label ID="txtDecs" runat="server"
              Text='<%# Eval("BriefDescription") %>' CssClass="dataValues" /><br />  
            <div class="actionBar"> 
               <asp:LinkButton ID="lbtnEdit" runat="server" CommandName="Edit" Text="Edit Book" />  
            </div>            
            </div>
         </ItemTemplate>
         <EditItemTemplate>
            <div class="singleBook">
            ISBN:
            <br />
            <asp:Label ID="labEditIsbn" runat="server" 
                Text='<%# Eval("ISBN") %>' CssClass="dataValues" /><br />
            Tytu:<br />
            <asp:TextBox ID="txtTitle" runat="server" CssClass="dataValues"
               Text='<%# Bind("Title") %>' Columns="75" /><br />
            Wydawca:<br />
            <asp:DropDownList ID="drpPublisher" runat="server" DataSourceID="dsPublisher" DataValueField="PublisherId"
               DataTextField="PublisherName" SelectedValue='<%# Bind("PublisherId") %>' />
            <br />
            Rok:<br />
            <asp:TextBox ID="txtYear" runat="server" CssClass="dataValues"
               Text='<%# Bind("YearPublished") %>' Columns="4" /><br />
            Opis:<br />
            <asp:TextBox ID="txtDesc" runat="server" 
               Text='<%# Bind("BriefDescription") %>' CssClass="dataValues"
               Columns="60" Rows="5" TextMode="MultiLine" /><br />
            <asp:RequiredFieldValidator ID="reqTitle" runat="server" EnableClientScript="false"
              ControlToValidate="txtTitle" ErrorMessage="Tytu nie moe by pusty" />
            <div class="actionBar">
               <asp:LinkButton ID="lbtnUpdate" runat="server" Text="Zapisz zmiany" CommandName="Update" />
               <asp:LinkButton ID="lbtnCancel" runat="server" Text="Anuluj zmiany" CommandName="Cancel" />
            </div>
            </div>
         </EditItemTemplate>
         <PagerStyle CssClass="singleBookTitle" />
         <PagerSettings Mode="NextPreviousFirstLast" 
            FirstPageImageUrl="images/page_first.gif"
            LastPageImageUrl="images/page_last.gif"
            NextPageImageUrl="images/page_next.gif"
            PreviousPageImageUrl="images/page_previous.gif"/>
      </asp:FormView>

      </div>
      <asp:SqlDataSource ID="dsBooks" runat="server"
       ProviderName="System.Data.OleDb" 
       ConnectionString="<%$ ConnectionStrings:Books %>"
       SelectCommand="SELECT ISBN,Title,PublisherName,Books.PublisherId,YearPublished,BriefDescription FROM Books INNER JOIN Publishers ON Books.PublisherId=Publishers.PublisherId"
       UpdateCommand="UPDATE Books SET Title=@Title,PublisherId=@PublisherId,YearPublished=@YearPublished,BriefDescription=@BriefDescription WHERE ISBN=@ISBN">
       
      </asp:SqlDataSource>
      <asp:SqlDataSource ID="dsPublisher" runat="server"
          ProviderName="System.Data.OleDb" 
          ConnectionString="<%$ ConnectionStrings:Books %>"
          SelectCommand="Select PublisherId,PublisherName From Publishers" />                    

	</form>
</body>
</html>
