using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class ButtonGridView : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {

   }
protected void grdSample_RowCommand(object sender, GridViewCommandEventArgs e)
{
   // Sprawd, ktre polecenie wygenerowao to zdarzenie
   if (e.CommandName == "AddCart")
   {
      // Pobierz indeks wiersza, ktry wygenerowa zdarzenie
      int rowIndex = Convert.ToInt32(e.CommandArgument);

      // Pobierz zbir wartoci kluczy wiersza
      DataKey rowKeys = grdSample.DataKeys[rowIndex];

      // Pobierz isbn i tytu z wartoci kluczy
      string isbn = (string)rowKeys.Values["Isbn"];
      string title = (string)rowKeys.Values["Title"];

      // Dodaj ksike do koszyk
      AddBookToCart(isbn, title);
   }
}

private void AddBookToCart(string isbn, string title)
{
   // pobierz koszyk dla tej sesji
   ArrayList cart = (ArrayList)Session["cart"];
   // Jeli koszyka nie ma w sesji, utwrz go
   if (cart == null)
   {
      cart = new ArrayList();
   }
   
   // Sprawd, czy w koszyku nie ma ju tego numeru isbn
   foreach (CartItem ci in cart)
   {
      if (ci.Isbn == isbn)
         return;
   }

   // Utwrz element koszyka i dodaj go do koszyka
   CartItem item = new CartItem(isbn, title);
   cart.Add(item);

   // Zachowaj zaktualizowany koszyk w sesji 
   Session["cart"] = cart;

   // Powi kontrolk GridView z koszykiem
   grdCart.DataSource = cart;
   grdCart.DataBind();
}


}
