using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class PopupDateNoAtlas : System.Web.UI.Page
{
   protected void txtChosenDate_TextChanged(object sender, EventArgs e)
   {
      DateTime dt = new DateTime();
      DateTime.TryParse(txtChosenDate.Text, out dt);

      calDatePicker.SelectedDate = dt;
      calDatePicker.VisibleDate = dt;
   }

   protected void imgbtnShowDatePickerPopOut_Click(object sender, ImageClickEventArgs e)
   {
      // przecza wywietlanie panela
      panDatePickerPopOut.Visible = !panDatePickerPopOut.Visible;

      // wsprzdne maj wartoci wzgldne w stosunku do kontrolki
      int heightOffset = (int)imgbtnShowDatePickerPopOut.Height.Value + 8;
      SetDatePickerPopOutStyle(e.X + heightOffset, e.Y - 1);
   }

   private void SetDatePickerPopOutStyle(int x, int y)
   {
      panDatePickerPopOut.CssClass = "PopUpShow";
      panDatePickerPopOut.Attributes.Add("style", "top:" + x + "px;left:" + y + "px;");
   }

   protected void calDatePicker_SelectionChanged(object sender, EventArgs e)
   {
      SetDateSelectionAndVisible();
   }

   protected void lnkbtnCloseDatePickerPopOut_Click(object sender, EventArgs e)
   {
      SetDateSelectionAndVisible();
   }

   private void SetDateSelectionAndVisible()
   {
      txtChosenDate.Text = calDatePicker.SelectedDate.ToShortDateString();
      panDatePickerPopOut.Visible = false;
   }
}
