<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ObjectDataEditor.aspx.cs" Inherits="ObjectDataEditor" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
   <title>Edytor danych korzystajcy z ObjectDataSource</title>
   <link href="chapterStyles.css" type="text/css" rel="stylesheet" />
   <style type="text/css"">
      .books { padding: 0.25em; background-color: beige; border: solid 1pt black;}
      .buttonRow { padding: 0.25em; background-color: silver; }
   </style>
</head>
<body>
   <form id="form1" runat="server">
      <div id="container">
         <h1>Edytor danych korzystajcy z ObjectDataSource</h1>
         <p>
         Przykad ten ilustruje uycie kontrolek <code>ObjectDataSource</code>. Kada
         z tych kontrolek korzysta z przykadowego obiektu dostpu do danych.
         </p>
         <h2>Wybierz ksik z listy.</h2>
         <p>
         <asp:ListBox id="lboxBooks" runat="server" 
            DataTextField="Isbn" DataValueField="ISBN" 
            AutoPostBack="true"  DataSourceID="objAllBooks"
             />
         </p>
         <asp:Panel id="panBook" runat="server" CssClass="books">
            <h2>Informacje o ksice</h2>
            <asp:DetailsView ID="dvBooks" runat="server" DataSourceID="objBook" 
               AutoGenerateEditButton="true" />
         </asp:Panel>
         <p>
         <asp:Label ID="labMsg" runat="server" />
         </p>
      </div>

      <asp:ObjectDataSource ID="objAllBooks" runat="server" 
         EnableCaching="true" 
         SelectMethod="GetAll" TypeName="BookDA" />    
         
      <asp:ObjectDataSource ID="objBook" runat="server"
         SelectMethod="GetBooksByIsbn" TypeName="BookDA" 
         UpdateMethod="UpdateBook" >
         <SelectParameters>
            <asp:ControlParameter ControlID="lboxBooks"
               Name="isbn" PropertyName="SelectedValue"
               Type="String" DefaultValue="a"/>
         </SelectParameters>
         <UpdateParameters>
            <asp:Parameter Name="isbn" Type="String" />
            <asp:Parameter Name="title" Type="String" />
            <asp:Parameter Name="yearPublished" Type="Int32" />
         </UpdateParameters>
      </asp:ObjectDataSource>               
   </form>
</body>
</html>


