using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Data.SqlClient;

public partial class LocalTransactions : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
       ModifyData();
    }

   private void ModifyData()
   {
      // Definicja poczenia do bazy danych, zmieni w razie potrzeby
      string connString = ConfigurationManager.ConnectionStrings["BookCatalog"].ConnectionString;

      int pubIdToDelete = 9;

      // Pobranie poczenia do bazy daych
      SqlConnection conn = new SqlConnection(connString);

      SqlTransaction trans = null;
      try
      {
         conn.Open();

         trans = conn.BeginTransaction();

         // Tworzenie pierwszej instrukcji SQL
         string sqlA = "DELETE FROM Publishers ";
         sqlA += " WHERE PublisherId=@pubid";

         // Utworzenie pierwszego obiektu polecenia
         SqlCommand cmdA = new SqlCommand(sqlA, conn, trans);

         // Dodanie parametru
         cmdA.Parameters.AddWithValue("@pubId", pubIdToDelete);

         // Wykonanie pierwszego zapytania
         cmdA.ExecuteNonQuery();

         // Tworzenie drugiej instrukcji z rozmylnym bdem,
         // ktry pozwoli na pokazanie dziaania transakcji
         string sqlB = "DELETE FROM NonExistantTable ";
         sqlB += " WHERE PublisherId=@pubid";

         // Utworzenie drugiego obiektu polecenia
         SqlCommand cmdB = new SqlCommand(sqlB, conn, trans);

         // Dodanie parametru
         cmdB.Parameters.AddWithValue("@pubId", pubIdToDelete);

         // Wykonanie drugiego polecenia
         cmdB.ExecuteNonQuery();

         trans.Commit();
         labMsg.Text = "Udana modyfikacja bazy danych";
      }
      catch (Exception ex)
      {
         labMsg.Text = "[btnUpdate_Click] ";
         labMsg.Text += "Podczas wykonywania operacji na bazie danych wystpi bd";
         labMsg.Text += "<br/>" + ex.Message;
         if (trans != null)
         {
            trans.Rollback();
            labMsg.Text += "<br/>" + "Zmiany zostay wycofane";
         }
      }
      finally
      {
         conn.Close();
         conn = null;
      }
   }
}
