using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;


/// <summary>
/// Hermetyzuje dane pojedynczego klienta
/// </summary>
public class Customer: AbstractEntity 
{
   // dane skadowe
   private string _firstName;
   private string _lastName;
   private string _phone;

   // Konstruktor
   public Customer(string id, string firstName, string lastName, string phone): base(id)
   {
      _firstName = firstName;
      _lastName = lastName;
      _phone = phone;
   }

   // Waciwoci
   public string FirstName
   {
      get { return _firstName; }
      set { _firstName = value; }
   }
   public string LastName
   {
      get { return _lastName; }
      set { _lastName = value; }
   }
   public string Phone
   {
      get { return _phone; }
      set { _phone = value; }
   }
   public string Name
   {
      get { return  FirstName + " " + LastName; }
   }

   public override bool IsValid
   {
      get
      {
         if (Id.Length > 0 && LastName.Length > 0)
            return true;
         else
            return false;
      }
   }

   public override string ToString()
   {
      return Id + "," + Name + "," + Phone; 
   }
}
