using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class DataBaseTree : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      if (!IsPostBack)
      {
         // get all the groups and iterate through them
         string[] groups = ProductCatalog.GetGroups();
         foreach (string grp in groups)
         {
            // create the node for the group
            TreeNode groupNode = new TreeNode(grp);
            // for each group get their subheadings and process them
            string[] subheadings = ProductCatalog.GetSubHeadingsByGroup(grp);
            foreach (string sub in subheadings)
            {
               // create the node for the subheading
               TreeNode subheadingNode = new TreeNode(sub);

               // for each subheading, get their groups and process them
               string[] products = ProductCatalog.GetProductsBySubHeading(sub);
               foreach (string prod in products)
               {
                  TreeNode productNode = new TreeNode(prod);
                  // add product node to its parent
                  subheadingNode.ChildNodes.Add(productNode);
               }
               // add subheading node to its parent
               groupNode.ChildNodes.Add(subheadingNode);
            }
            // add group node to its parent
            treeMain.Nodes.Add(groupNode);
         }
      }
   }
}
