using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;


using System.Text.RegularExpressions;

public partial class Highlighting : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
       labContent.Text = "Client-side validation is useful because it reduces round-trips to the server. This provides immediate feedback to the user as well as improves server performance. Unfortunately, client-side validation by itself is not sufficient. The user could be using a browser that does not support scripting (that is, using an ancient browser or has scripting turned off via the browser preferences). As well, client-side scripting is potentially vulnerable to script exploits. These can happen when a malicious user enters a javascript &lt;script&gt; block into a text field that can later cause harm when the entered data is echoed back to the browser.";
    }

   protected void btnSearch_Click(object sender, EventArgs e)
   {
      // set up the regular expression
      Regex myreg = new Regex(txtSearch.Text, RegexOptions.IgnoreCase);

      // highlight words by calling the delegate each time a match is found
      labContent.Text = myreg.Replace(labContent.Text, new MatchEvaluator(ReplaceSearchWord));
   }

   /// <summary>
   /// Delegate for 
   /// </summary>
   public string ReplaceSearchWord(Match m)
   {
      return "<span style='font-weight:bold; background: yellow;'>" + m.Value + "</span>";
   }
}
