<%@ Application Language="C#" %>

<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Net.Mail" %>
<%@ Import Namespace="System.IO" %>

<script runat="server">

 
   void Application_Error(object sender, EventArgs e) 
   {
      try
      {
         // pobranie znacznika dziennika bdu z pliku web.config
         string sLogErrors = ConfigurationManager.AppSettings["Error_ShouldLogErrors"];
         bool logErrors = Convert.ToBoolean(sLogErrors);

         // rejestrujemy bdy tylko w przypadku wczonej opcji w web.config
         if (logErrors)
         {
            // Zapisanie dziennika bdw w folderze App_Data
            string path = Server.MapPath("~/App_Data/ExceptionLog.txt");

            // doczenie do pliku nastpujcych danych
            StreamWriter sw = File.AppendText(path);
            sw.WriteLine("----------------------------------------------");
            sw.WriteLine(DateTime.Now + " " + Request.Path);
            sw.WriteLine(Server.GetLastError().ToString());
            sw.WriteLine();
            sw.Flush();
            sw.Close();
         }
      }
      catch (Exception ex)
      {
         // nie mona zbyt wiele zrobi z tym bdem, poza skierowaniem do wyjcia bdw
         Debug.WriteLine(ex.Message);
      }
         
         
      
      // construct the error string
      string msg = "Url " + Request.Path + "Error: " + Server.GetLastError().ToString();

      // need to catch exception in case we do not have permission to access Event Log
      try
      {
         // create the WebErrors event source if we need to
         string logName = "WebErrors";
         
         if (!EventLog.SourceExists(logName))
            EventLog.CreateEventSource(logName, logName);

         // add a new error event to the log
         EventLog log = new EventLog();
         log.Source = logName;
         log.WriteEntry(msg, EventLogEntryType.Error);
      }
      catch (Exception ex)
      {
         // not much we can do with this except output it to debugger
         Debug.WriteLine(ex.Message);
      }

      /*      
            MailMessage mail = new MailMessage();


            string to = ConfigurationManager.AppSettings["ErrorHandler_ToEmail"];
            mail.To.Add(new MailAddress(to));
            string from = ConfigurationManager.AppSettings["ErrorHandler_FromEmail"];
            mail.From = new MailAddress(from);
            mail.Subject = "Critical Application Exception";
            mail.IsBodyHtml = true;

            string body = "<html><head></head><body>";
            body += "<h1>" + Request.Path + "</h1>";
            body += "<h2>" + DateTime.Now + "</h2>";
            body += Server.GetLastError().ToString();
            body += "</body></html>";
            mail.Body = body;
      
            SmtpClient mailer = new SmtpClient();
            mailer.Host = ConfigurationManager.AppSettings["ErrorHandler_SmtpHost"];
            try
            {
               mailer.Send(mail);
            }
            catch (Exception ex)
            {
               // not much we can do with this except output it to debugger
               Debug.WriteLine(ex.Message);
            }
            */
   }

</script>
