﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="MultiViewTest.aspx.cs" Inherits="MultiViewTest" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
   <title>MultiView Class Example</title>
   <link href="chapterStyles.css" type="text/css" rel="stylesheet" />
   <style type="text/css">

      .TabContainer
      {
         font: bold 0.75em Verdana;
         width: 60em;
         margin-top: 1.5em;
         padding-top: 2em;
      }
      .TabItemInactive
      {
         border-top: 1px solid white;
         border-left: 1px solid white;
         border-right: 1px solid #aaaaaa;
         border-bottom: none;      
         background-color: #d3d3d3;  
         text-align: center; 
         text-decoration: none;
         padding: 0.75em 0.25em 0 0.25em;
      }

      .TabItemInactive:hover
      {
         background: #808080;
      }   
      .TabItemActive
      {     
         border-top: 1px solid white;
         border-left: none;
         border-right: 1px solid #aaaaaa;
         border-bottom: none;
         text-decoration: none;
         background-color: #bbbbbb;  
         text-align: center;   
         padding: 0.75em 0.25em 0 0.25em;
      }

      .ContentPanel
      {
         background-color: #bbbbbb; 
         padding: 10px 10px 10px 10px;
         width: 60em;
         font: 0.8em Verdana;
      }
  </style>
</head>
<body>
   <form id="form1" runat="server">
      <div id="container">
      <h1>Test kontrolek MultiView i View</h1>
      <asp:MultiView ID="mviewMain" runat="Server" ActiveViewIndex="0">

         <asp:View ID="CustomerView" runat="Server">
            <asp:Panel ID="panelNavigatonView1" runat="server" CssClass="TabContainer" Width="630px">
               <asp:Label ID="labOne" runat="Server" 
                  CssClass="TabItemActive" Text="Dane klienta" />
               <asp:LinkButton ID="lnkb_DefaultBook" runat="Server" CommandName="Book" CssClass="TabItemInactive"
                   OnCommand="LinkButton_Command" Text="Książki wybrane przez klienta">
               </asp:LinkButton>
               <asp:LinkButton ID="lnkb_DefaultCategories" CssClass="TabItemInactive" 
                  Text="Kategorie klienta" runat="server"
                  OnCommand="LinkButton_Command" 
                  CommandName="Categories" />
            </asp:Panel>
            <asp:Panel ID="panelView1" runat="server" CssClass="ContentPanel" Width="460px">          
               <h2>Dane klienta</h2>
               <p>Imię:<asp:TextBox ID="txtFirst" runat="server" /></p>
               <p>Nazwisko:<asp:TextBox ID="txtLast" runat="server" /></p>
               <p>Telefon:<asp:TextBox ID="txtPhone" runat="server" /></p>
               <asp:Button id="view1Next" runat="Server" Width="6em"
                  Text="Dalej" CommandName="NextView" />
            </asp:Panel>
         </asp:View>
         
         <asp:View ID="BookView" runat="Server">
            <asp:Panel ID="panelNavigatonView2" runat="server" CssClass="TabContainer" Width="630px">
               <asp:LinkButton ID="lnkb_BookCustomer" runat="Server"
                  CssClass="TabItemInactive" Text="Dane klienta"
                  OnCommand="LinkButton_Command" 
                  CommandName="Customer"  />
               <asp:Label ID="Label3" runat="Server" CssClass="TabItemActive" 
                  Text="Książki wybrane przez klienta">
               </asp:Label>
               <asp:LinkButton ID="lnkb_BookCategories" runat="server"
                  CssClass="TabItemInactive" Text="Kategorie klienta"
                  OnCommand="LinkButton_Command" 
                  CommandName="Categories"  />
            </asp:Panel>
            <asp:Panel ID="panelView2" runat="server" CssClass="ContentPanel" Width="457px"> 
               <h2>Ksiażki wybrane przez klienta</h2>
               <p>
                  <em>Core JavaServer Faces</em>
                  <br />Cay Horstmann, David Geary
               </p>
               <p>
                  <em>Patterns of Enterprise Application Architecture</em>
                  <br />Martin Fowler
               </p>               
               <asp:Button id="view2Back" runat= "Server"
                 Text="Poprzedni" CommandName="PrevView" Width="6em" />
               <asp:Button id="view2Next" runat="Server"
                 Text="Następny" CommandName="NextView" Width="6em" /> 
            </asp:Panel>
         </asp:View>
         
         <asp:View ID="CategoriesView" runat="Server">
            <asp:Panel ID="panelNavigatonView3" runat="server" CssClass="TabContainer" Width="629px">
               <asp:LinkButton ID="lnkb_CategoriesCustomer" runat="Server"
                  CssClass="TabItemInactive" 
                  Text="Dane klienta"
                  OnCommand="LinkButton_Command" 
                  CommandName="Customer" />
               <asp:LinkButton ID="lnkb_CategoriesBook" runat="Server"
                  CssClass="TabItemInactive" 
                  Text="Książki wybrane przez klienta"
                  OnCommand="LinkButton_Command" 
                  CommandName="Book" />
               <asp:Label ID="Label4" runat="Server" CssClass="TabItemActive" 
                  Text="Kategorie klienta" />
            </asp:Panel>
            <asp:Panel ID="panelView3" runat="server" CssClass="ContentPanel" Width="453px"> 
               <h2>Kategorie klienta</h2>
               <p>Programowanie</p>
               <p>Technologie obiektowe</p>
            <asp:Button id="view3Prev" runat= "Server"
              Text="Poprzedni" CommandName="PrevView" Width="6em" />  
            <asp:Button id="view3First" runat= "Server"
              Text="Początek"
              CommandName="SwitchViewByIndex"
              CommandArgument="0" Width="6em" />                 
            </asp:Panel>
         </asp:View>
      </asp:MultiView>
   </div>
   </form>
</body>
</html>
