using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class CalenderRender : System.Web.UI.Page
{
    private ArrayList _events;

    protected void Page_Load(object sender, EventArgs e)
    {
        FillCalender();
    }

    /// <summary>
    /// Dodaje zdarzenia do kalendarza.
    /// </summary>
    private void FillCalender()
    {
        // Na razie, na stae wpisujemy kod zdarze. 
        // W rzeczywistoci powinny by pobierane z bazy danych
        _events = new ArrayList();

        // Tworzenie kilku przykadowych zdarze. Przypisanie ich do daty biecej,
        // dwa dni od dzisiaj oraz pi dni od dzisiaj
        _events.Add(new CalenderEvent("Wizyta u lekarza", "10:00 spotkanie z dr Nowakiem", DateTime.Now, CalenderEvent.EventTypes.Appointment));
        _events.Add(new CalenderEvent("Nauka ASP.NET", "Nauczenie si ASP.NET w celu przygotowania do konferencji", DateTime.Now.AddDays(2.0), CalenderEvent.EventTypes.ToDoReminder));
        _events.Add(new CalenderEvent("Konferencja PDA", "Konferencja Microsoft .NET PDA, Seattle", DateTime.Now.AddDays(5.0), CalenderEvent.EventTypes.AllDayEvent));
    }

    /// <summary>
    /// Obsuguje zdarzenie generowania dnia.
    /// </summary>
    protected void calRender_DayRender(object sender, DayRenderEventArgs e)
    {
        // pobranie daty do wygenerowania
        DateTime renderDay = e.Day.Date;
        // jeeli ta data znajduje si na naszej licie zdarze
        foreach (CalenderEvent cEvent in _events)
        {
            // jeeli data jest identyczna, dodanie odpowiedniego obrazu
            if (renderDay.ToShortDateString() == cEvent.Date.ToShortDateString())
            {
                Image img = new Image();
                img.ImageUrl = "~/images/" + cEvent.ImageFile;
                img.ToolTip = cEvent.ShortDescription;
                img.ImageAlign = ImageAlign.Middle;
                e.Cell.Controls.Add(img);
            }
        }
    }

    /// <summary>
    /// Obsuguje wybranie zdarzenia w kalendarzu
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void calRender_SelectionChanged(object sender, EventArgs e)
    {
        // pobranie wybranej daty
        DateTime selectDay = calRender.SelectedDate;
        string message = "";
        // sprawdzenie, czy data znajduje si na naszej licie zdarze
        foreach (CalenderEvent cEvent in _events)
        {
            if (selectDay.ToShortDateString() == cEvent.Date.ToShortDateString())
            {
                message = cEvent.ToString();
            }
        }
        // przypisanie odpowiedniego komunikatu do etykiety
        if (message == "")
            labMessage.Text = "Brak zdarze zaplanowanych na " + selectDay.ToShortDateString();
        else
            labMessage.Text = message;

    }
}
