using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using System.Text;

/// <summary>
/// Hermetyzuje pojedyncze zdarzenie kalendarza
/// </summary>
public class CalenderEvent
{
    /// <summary>
    /// Reprezentuje moliwe typy zdarze daty
    /// </summary>
    public enum EventTypes
    {
        AllDayEvent, Appointment, ToDoReminder
    }

    // dane skadowe
    private string _shortDescription;
    private string _fullDescription;
    private DateTime _eventDate;
    private EventTypes _eventType;

    public CalenderEvent(string shortDescription, string fullDescription, DateTime eventDate, EventTypes eventType)
    {
        _shortDescription = shortDescription;
        _fullDescription = fullDescription;
        _eventDate = eventDate;
        _eventType = eventType;
    }

    /// <summary>
    /// Przesonicie metody ToString() w celu zapewnienia 
    /// reprezentacji znakowej zdarzenia. 
    /// </summary>
    /// <returns></returns>
    public override string ToString()
    {
        // uycie StringBuilder dla zapewnienia bardziej efektywnego czenia cigw
        StringBuilder sb = new StringBuilder();
        sb.Append(this.Date.ToShortDateString());
        sb.Append(" -- ");
        sb.Append(this.EventTypeString);
        sb.Append("<br/>");
        sb.Append(FullDescription);
        return sb.ToString();
    }

    /// <summary>
    /// Peny opis zdarzenia.
    /// </summary>
    public string FullDescription
    {
        get { return _fullDescription; }
        set { _fullDescription = value; }
    }

    /// <summary>
    /// Krtki opis zdarzenia.
    /// </summary>
    public string ShortDescription
    {
        get { return _shortDescription; }
        set { _shortDescription = value; }
    }

    /// <summary>
    /// Data zdarzenia.
    /// </summary>
    public DateTime Date
    {
        get { return _eventDate; }
        set { _eventDate = value; }
    }

    /// <summary>
    /// Typ zdarzenia
    /// </summary>
    public EventTypes Type
    {
        get { return _eventType; }
        set { _eventType = value; }
    }

    /// <summary>
    /// Zwraca reprezentacj znakow typu zdarzenia
    /// </summary>
    public string EventTypeString
    {
        get
        {
            if (this.Type == EventTypes.AllDayEvent)
                return "Zdarzenie caodzienne";
            else if (this.Type == EventTypes.Appointment)
                return "Spotkanie";
            else
                return "Do wykonania";
        }
    }

    /// <summary>
    /// Zwraca nazw pliku z ikon danegotypu zdarzenia
    /// </summary>
    public string ImageFile
    {
        get
        {
            if (this.Type == EventTypes.AllDayEvent)
                return "cal_allday.gif";
            else if (this.Type == EventTypes.Appointment)
                return "cal_appointment.gif";
            else
                return "cal_todo.gif";
        }
    }
}
