using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Configuration;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

using com.amazon.webservices;

public partial class AmazonBookControl : System.Web.UI.UserControl
{
   private string _isbn = "";

   /// <summary>
   /// Jeli kontrolka jest wczytywana po raz pierwszy, zaaduj dane i ukryj panel z recenzjami
   /// </summary>
   protected void Page_Load(object sender, EventArgs e)
   {
      if (! IsPostBack)
      {
         lnkReviews.Text = "Poka recenzje";
         panReviews.Visible = false;
         RefreshControlFromAmazon();  
      }           
   }

   /// <summary>
   /// Wczytuje kontrolk z danymi o ksice okrelonej numerem isbn
   /// </summary>
   public void RefreshControlFromAmazon()
   {
      try
      {
         // utwrz klas poredniczc usugi web Amazon
         AWSECommerceService ecs = new AWSECommerceService();
         // ustaw czas oczekiwania na 10 sekund (10000 milisekund)
         ecs.Timeout = 10000;

         // Utwrz obiekt szukania elementu w witrynie Amazon 
         ItemLookup itemLookup = new ItemLookup();
         // Zapenij klucz dostpu do witryny Amazon na podstawie pliku Web.config
         itemLookup.AWSAccessKeyId = WebConfigurationManager.AppSettings["AWSaccessKey"];

         // Utwrz obiekt dania szukania elementu w witrynie Amazon i zapenij go
         ItemLookupRequest amazonRequest = new ItemLookupRequest();
         // Okrel, jaki rodzaj informacji chcesz uzyska
         amazonRequest.ResponseGroup = new string[] { "ItemAttributes", "Reviews", "Images" };
         // okrel numer isbn szukanego elementu
         amazonRequest.ItemId = new string[] { ISBN };
         amazonRequest.IdType = ItemLookupRequestIdType.ASIN;
         amazonRequest.IdTypeSpecified = true;

         // Dodaj danie do poszukiwania
         itemLookup.Request = new ItemLookupRequest[] { amazonRequest };

         // Wykonaj poszukiwanie i pobierz obiekt z odpowiedzi
         ItemLookupResponse amazonResponse = ecs.ItemLookup(itemLookup);

         // Jeli obiekt z odpowiedzi jest pusty, wywietl komunikat o bdzie i wyjd
         if (amazonResponse == null)
         {
            labError.Text = "Bd Amazona - nie uzyskano odpowiedzi!";
            return;
         }

         // Teraz przeszukaj model obiektu w celu odnalezienia
         // obiektu z odpowiedzi, aby uzyska dane o ksice
         Items[] itemsArray = amazonResponse.Items;

         // Sprawd, czy wystpiy bdy i jeli tak, zatrzymaj si
         if (itemsArray == null)
         {
            labError.Text = "Bd Amazona - pusta odpowied!";
            return;
         }
         if (itemsArray[0].Request.Errors != null)
         {
            labError.Text = itemsArray[0].Request.Errors[0].Message;
            return;
         }

         // Na koniec mona pobra uzyskane dane o ksice
         Item book = amazonResponse.Items[0].Item[0];
         if (book != null)
         {
            // Skonfiguruj kontrolki w oparciu o dane o ksice
            imgBook.ImageUrl = book.MediumImage.URL;
            hypTitle.Text = book.ItemAttributes.Title;
            hypTitle.NavigateUrl = book.DetailPageURL;

            // Powi kontrolk Repeater z tablic recenzji (jeeli recenzje istniej)
            CustomerReviews customerReviews = book.CustomerReviews;
            if (customerReviews != null)
            {
               Review[] reviewArray = customerReviews.Review;
               rptReviews.DataSource = reviewArray;
               rptReviews.DataBind();
            }
         }
      }
      catch (Exception ex)
      {
         labError.Text = ex.Message;
         return;
      }
   }

   /// <summary>
   /// Okrela szukany numer isbn
   /// </summary>
   public string ISBN
   {
      get { return _isbn; }
      set { _isbn = value; }
   }

   /// <summary>
   /// Funkcja obsugi przycisku wywietlajcego i ukrywajcego recenzje
   /// </summary>
   protected void lnkReviews_Click(object sender, EventArgs e)
   {
      if (lnkReviews.Text == "Poka recenzje")
      {
         panReviews.Visible = true;
         lnkReviews.Text = "Ukryj recenzje";
      }
      else
      {
         panReviews.Visible = false;
         lnkReviews.Text = "Poka recenzje";
      }

   }
}
