using System;
using System.Data;

namespace FourLayer.BusinessEntity
{
   /// <summary>
   /// Encapsulates the data for a single book publisher
   /// </summary>
   [Serializable]
   public class Publisher: AbstractEntity 
   {

      // data members
      private string _name;
      private string _homeUrl;
      private string _rssUrl;

      public Publisher() { }
      public Publisher(int id, string name)
         : base(id)
      {
         _name = name;
      }
      public Publisher(int id, string name, string homeUrl, string rssUrl)
         : base(id)
      {
         _name = name;
         _homeUrl = homeUrl;
         _rssUrl = rssUrl;
      }
      
      public int Id
      {
         get { return (int)Key; }
         set { Key = value; }
      }
      public string Name
      {
         get { return _name; }
         set { _name = value; }
      }
      public string HomePageUrl
      {
         get { return _homeUrl; }
         set { _homeUrl = value; }
      }
      public string RssUrl
      {
         get { return _rssUrl; }
         set { _rssUrl = value; }
      }

      public override string ToString()
      {
         return Key + "," + Name;
      }

      /// <summary>
      /// Determines if this object's state is valid
      /// </summary>
      protected override bool CheckIfSubClassStateIsValid
      {
         get
         {
            if (Name == null)
            {
               AddBrokenRule("Publisher: Name is null");
               return false;
            }

            if (Name.Length > 0)
               return true;
            else
            {
               AddBrokenRule("Publisher: Name is empty");
               return false;
            }
         }
      }
   }
}
