using System;
using System.Data;
using System.Collections.Generic;

namespace FourLayer.BusinessEntity
{

   /// <summary>
   /// Summary description for AbstractEntity
   /// </summary>
   [Serializable]
   public abstract class AbstractEntity
   {
      // data members
      private object _key;
      // collection of descriptions of all broken rules
      private List<string> _brokenRules = new List<string>();

      public AbstractEntity()
      {
         _key = 0;
      }
      public AbstractEntity(object key)
      {
         _key = key;
      }

      /// <summary>
      /// Every entity must have a key
      /// </summary>
      public object Key
      {
         get { return _key; }
         set { _key = value; }
      }


      /// <summary>
      /// Each subclass will be responsible for checking if its
      /// own state (data members) has any broken business rules
      /// </summary>
      protected abstract bool CheckIfSubClassStateIsValid
      {
         get;
      }

      /// <summary>
      /// Subclasses need ability to add broken rule description
      /// </summary>
      protected void AddBrokenRule(string rule)
      {
         _brokenRules.Add(rule);
      }
      /// <summary>
      /// Return the descriptions of any broken rules
      /// </summary>
      public List<string> BrokenRules
      {
         get { return _brokenRules; }
      }
      /// <summary>
      /// Is the business object valid
      /// </summary>
      public bool IsValid
      {
         get
         {
            _brokenRules.Clear();
            return CheckIfSubClassStateIsValid;
         }
      }
   }
}