using System;
using System.Collections;
using System.Collections.Generic;

namespace FourLayer.BusinessEntity
{

   /// <summary>
   /// Oglny zbir encji biznesowych aplikacji
   /// </summary>
   [Serializable]
   public class EntityCollection<T> : IEnumerable<T> where T : AbstractEntity
   {
      // dane skadowe
      private List<T> _entities;

      /// <summary>
      /// Konstruktor inicjalizuje zbir wewntrzny
      /// </summary>
      public EntityCollection()
      {
         _entities = new List<T>();
      }

      /// <summary>
      /// Dodaj encj do zbioru
      /// </summary>
      public void Add(T entity)
      {
         _entities.Add(entity);
      }

      public void Remove(T entity)
      {
         _entities.Remove(entity);
      }

      public void Clear(T entity)
      {
         _entities.Clear();
      }

      /// <summary>
      /// Indekser umoliwiajcy pobranie elementu ze zbioru na podstawie indeksu numerycznego
      /// </summary>
      public T this[int index]
      {
         get
         {
            if (index >= 0 && index < _entities.Count)
               return _entities[index];
            else
               return default(T);
         }
      }

      /// <summary>
      /// Odszukaj klienta o przekazanej wartoci identyfikatora
      /// </summary>
      public T FindByKey(object key)
      {
         foreach (T entity in _entities)
         {
            if (entity.Key == key)
               return entity;
         }
         return null;
      }

      /// <summary>
      /// Sprawdza, czy zbir jest prawidowy, proszc, aby
      /// kady element zbioru sprawdzi, czy sam jest prawidowy
      /// </summary>
      public bool IsValid()
      {
         bool valid = true;
         foreach (T entity in _entities)
         {
            if (!entity.IsValid)
               valid = false;
         }
         return valid;
      }

      /// <summary>
      /// Musi zaimplementowa GetEnumerator dla IEnumerable&lt;T&gt;
      /// 
      /// Implementacja tego interfejsu umoliwi iterowanie zbioru za pomoc instrukcji foreach
      /// (a tym samym umoliwi uycie zbioru do wizania danych)
      /// </summary>
      public IEnumerator<T> GetEnumerator()
      {
         return _entities.GetEnumerator();
      }

      /// <summary>
      /// Musi zaimplementowa take GetEnumerator dla IEnumerable w celu umoliwienia iteracji.
      /// </summary>
      IEnumerator IEnumerable.GetEnumerator()
      {
         return GetEnumerator();
      }


      public int Count
      {
         get { return _entities.Count; }
      }

      
   }
}