using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

public partial class BookPortal : System.Web.UI.Page
{
   protected void Page_Load(object sender, EventArgs e)
   {
      if (!IsPostBack)
      {
         dsBooks.SelectMethod = "GetAllBooks";
      }
   }
   protected void grdPublisher_SelectedIndexChanged(object sender, EventArgs e)
   {
      dsBooks.SelectMethod = "GetBooksByPublisher";
      dsBooks.SelectParameters.Clear();
      Parameter p = new ControlParameter("pubId", "grdPublisher", "SelectedDataKey.Values[0]");
      dsBooks.SelectParameters.Add(p);
   }
   protected void grdSeries_SelectedIndexChanged(object sender, EventArgs e)
   {
      dsBooks.SelectMethod = "GetBooksBySeries";
      dsBooks.SelectParameters.Clear();
      Parameter p = new ControlParameter("seriesId", "grdSeries", "SelectedDataKey.Values[0]");
      dsBooks.SelectParameters.Add(p);
   }
   protected void grdCategory_SelectedIndexChanged(object sender, EventArgs e)
   {
      dsBooks.SelectMethod = "GetBooksByCategory";
      dsBooks.SelectParameters.Clear();
      Parameter p = new ControlParameter("catId", "grdCategories", "SelectedDataKey.Values[0]");
      dsBooks.SelectParameters.Add(p);
   }

   /// <summary>
   /// Wywoywane, gdy obiekt ksiki w kontrolce ObjectDataSource prbuje aktualizowa dane
   /// </summary>
   protected void dsBookSingle_Updating(object sender, ObjectDataSourceMethodEventArgs e)
   {
      // pobierz wypeniony parametr aktualizacji
      Book bk = (Book)e.InputParameters[0];

      // zapytaj encj, czy zostay naruszone jakiekolwiek reguy biznesowe
      if (!bk.IsValid)
      {
         // reguy zostay naruszone, a zatem anuluj aktualizacj
         e.Cancel = true;
      }
      // wywietl naruszone reguy biznesowe
      grdErrors.DataSource = bk.BrokenRules;
      grdErrors.DataBind();

   }

}
