using System;
using System.Data;
using System.Collections.Generic;
using System.Web;


using FourLayer.BusinessEntity;
using FourLayer.DataAccessObject;

namespace FourLayer.ApplicationLogic
{

   /// <summary>
   /// Obsuguje cao logiki aplikacji katalogu
   /// </summary>
   public class BookCatalogLogic
   {
      /*
      * Ksiki
      */


      public static EntityCollection<Author> GetBookAuthors(string isbn)
      {         
         Book b = GetBookByIsbn(isbn);
         return b.Authors;
      }
      public static void UpdateBook(Book book)
      {
         if (book.IsValid)
         {
            BookDAO dao = new BookDAO();
            dao.Update(book);
         }
      }
      public static void InsertBook(Book book)
      {
         BookDAO dao = new BookDAO();
         dao.Insert(book);
      }
      public static void DeleteBook(Book book)
      {
         BookDAO dao = new BookDAO();
         dao.Delete(book);
      }
      public static Book GetBookByIsbn(string isbn)
      {
         if (isbn == null)
            return null;

         Book b = (Book)HttpContext.Current.Cache[isbn];
         if (b == null)
         {
            BookDAO dao = new BookDAO();
            b = dao.GetByKey(isbn);
            if (b != null)
               HttpContext.Current.Cache[isbn] = b;
         }
         return b;
      }
      public static EntityCollection<Book> GetAllBooks()
      {
         BookDAO dao = new BookDAO();
         return dao.GetAll();
      }
      public static EntityCollection<Book> GetBooksByPublisher(int pubId)
      {
         BookDAO dao = new BookDAO();
         return dao.GetByCriteria("Books.PublisherId", "=", pubId);
      }
      public static EntityCollection<Book> GetBooksByCategory(int catId)
      {
         BookDAO dao = new BookDAO();
         return dao.GetByCriteria("Books.CategoryId", "=", catId);
      }
      public static EntityCollection<Book> GetBooksBySeries(int seriesId)
      {
         BookDAO dao = new BookDAO();
         return dao.GetByCriteria("Books.SeriesId", "=", seriesId);
      }


      /*
       * Wydawcy
       */

      public static EntityCollection<Publisher> GetAllPublishers()
      {
         PublisherDAO dao = new PublisherDAO();
         return dao.GetAll();
      }
      public static DataTable GetAllPublishersAsDataTable()
      {
         PublisherDAO dao = new PublisherDAO();
         EntityCollection<Publisher> collection = dao.GetAll();
         return dao.AdaptCollectionToDataTable(collection);
      }
      public static void UpdatePublisher(Publisher publisher)
      {
         PublisherDAO dao = new PublisherDAO();
         dao.Update(publisher);
      }
      public static void InsertPublisher(Publisher publisher)
      {
         PublisherDAO dao = new PublisherDAO();
         dao.Insert(publisher);
      }
      public static void DeletePublisher(Publisher publisher)
      {
         PublisherDAO dao = new PublisherDAO();
         dao.Delete(publisher);
      }
      public static Publisher GetPublisherById(int id)
      {
         PublisherDAO dao = new PublisherDAO();
         return dao.GetByKey(id);
      }


      /*
       * Serie
       */
      public static EntityCollection<Series> GetAllSeries()
      {
         SeriesDAO dao = new SeriesDAO();
         return dao.GetAll();
      }
      public static void UpdateSeries(Series series)
      {
         SeriesDAO dao = new SeriesDAO();
         dao.Update(series);
      }
      public static void InsertSeries(Series series)
      {
         SeriesDAO dao = new SeriesDAO();
         dao.Insert(series);
      }
      public static void DeleteSeries(Series series)
      {
         SeriesDAO dao = new SeriesDAO();
         dao.Delete(series);
      }
      public static Series GetSeriesById(int id)
      {
         SeriesDAO dao = new SeriesDAO();
         return dao.GetByKey(id);
      }

      /*
       * Kategorie
       */
      public static EntityCollection<Category> GetAllCategories()
      {
         CategoryDAO dao = new CategoryDAO();
         return dao.GetAll();
      }
      public static void UpdateCategory(Category category)
      {
         CategoryDAO dao = new CategoryDAO();
         dao.Update(category);
      }
      public static void InsertCategory(Category category)
      {
         CategoryDAO dao = new CategoryDAO();
         dao.Insert(category);
      }
      public static void DeleteCategory(Category category)
      {
         CategoryDAO dao = new CategoryDAO();
         dao.Delete(category);
      }
      public static Category GetCategoryById(int id)
      {
         CategoryDAO dao = new CategoryDAO();
         return dao.GetByKey(id);
      }

      /*
       * Autor
       */
      public static EntityCollection<Author> GetAllAuthors()
      {
         AuthorDAO dao = new AuthorDAO();
         return dao.GetAll();
      }
      public static void UpdateAuthor(Author author)
      {
         AuthorDAO dao = new AuthorDAO();
         dao.Update(author);
      }
      public static void InsertAuthor(Author author)
      {
         AuthorDAO dao = new AuthorDAO();
         dao.Insert(author);
      }
      public static void DeleteAuthor(Author author)
      {
         AuthorDAO dao = new AuthorDAO();
         dao.Delete(author);
      }
      public static Author GetAuthorById(int id)
      {
         AuthorDAO dao = new AuthorDAO();
         return dao.GetByKey(id);
      }
   }
}