using System;
using System.Data;
using System.Data.Common;

namespace TwoLayer.DataAccess
{
   /// <summary>
   /// 
   /// </summary>
   public class PublisherDA : AbstractDA
   {

      protected override string SelectStatement
      {
         get { return "SELECT PublisherId, PublisherName FROM Publishers"; }
      }

      /// <summary>
      /// Zwraca tabel z danymi zawierajc informacje o tabeli wydawcy dla okrelonego identyfikatora.
      /// Ten zbir danych bdzie zawiera 0 lub 1 wiersz danych.
      /// </summary>
      public override DataTable GetById(object oId)
      {
         int id = (int)oId;

         // utwrz sparametryzowan instrukcj zapytania
         string sql = SelectStatement + " WHERE PublisherId=@id";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
			   MakeParameter("@id", id, DbType.Int32)
			};

         // zwr wynik
         return GetDataTable(sql, parameters);
      }

      /// <summary>
      /// Zwraca tabel z danymi zawierajc informacje o tabeli wydawcy dla okrelonego identyfikatora.
      /// Ten zbir danych bdzie zawiera 0 lub 1 wiersz danych.
      /// </summary>
      public DataTable GetByName(string name)
      {
         // utwrz sparametryzowan instrukcj zapytania
         string sql = SelectStatement + " WHERE PublisherName=@name";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
			   MakeParameter("@name", name, DbType.String)
			};

         // zwr wynik
         return GetDataTable(sql, parameters);
      }


      public void UpdatePublisher(int publisherId, string publisherName)
      {
         string sql = "UPDATE Publishers SET PublisherName=@PublisherName";
         sql += " WHERE PublisherId=@PublisherId";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
            MakeParameter("@PublisherId", publisherId, DbType.Int32),
            MakeParameter("@PublisherName", publisherName, DbType.String)
			};

         // uruchom okrelon instrukcj
         RunNonQuery(sql, parameters);
      }

      public void InsertPublisher(string publisherName)
      {
         string sql = "INSERT INTO Publishers (PublisherName) ";
         sql += " VALUES (@PublisherName)";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
            MakeParameter("@PublisherName", publisherName, DbType.String)
			};

         // uruchom okrelon instrukcj
         RunNonQuery(sql, parameters);
      }

      public void DeletePublisher(int publisherId)
      {
         string sql = "DELETE FROM Publishers WHERE PublisherId=@PublisherId";

         // utwrz tablic parametrw
         DbParameter[] parameters = new DbParameter[] {
            MakeParameter("@PublisherId", publisherId, DbType.Int32)
			};

         // uruchom okrelon instrukcj
         RunNonQuery(sql, parameters);
      }

   }
}