using System;
using System.Data;
using System.Collections;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using FourLayer.ApplicationLogic;
using FourLayer.BusinessEntity;

public partial class ExtenderTester : System.Web.UI.Page
{
   /// <summary>
   /// Obsuguje zdarzenia zwizane z wybieraniem przez uytkownika ksiek w kontrolce GridView
   /// </summary>
   protected void grdBookList_SelectedIndexChanged(object sender, EventArgs e)
   {
      string isbn = (string)grdBookList.SelectedDataKey.Value;

      BookCatalogLogic logic = new BookCatalogLogic();
      Book book = logic.GetBookByIsbn(isbn);
      if (book != null) DisplayBook(book);    
   }

   /// <summary>
   /// Obsuga zdarzenia zwizanego z klikniciem przycisku szukania
   /// </summary>
   protected void btnSearch_Click(object sender, EventArgs e)
   {
      System.Threading.Thread.Sleep(2000);
      // sprbuj odczyta ksik na podstawie wprowadzanego tekstu
      BookCatalogLogic logic = new BookCatalogLogic();
      EntityCollection<Book> books = logic.GetBooksByTitle(txtSearch.Text);
      // jeli ksika zostaa odnaleziona, wywietl j w panelu
      if (books == null || books.Count <= 0)
         labNotFound.Text = "Ksiki nie odnaleziono";
      else
         DisplayBook(books[0]);
   }

   /// <summary>
   /// Wywietla informacje o ksice w panelu
   /// </summary>
   private void DisplayBook(Book book)
   {
      labNotFound.Text = "";
      labBookTitle.Text = book.Title;
      labBookAuthors.Text = book.AuthorsCommaList;
      labBookPublisher.Text = book.BookPublisher.Name;
      labBookDesc.Text = book.BriefDescription;
   }
}

/*
 ROZWIZANIE ALTERNATYWNE Z UYCIEM ROZSZERZE
 * 
<atlas:AutoCompleteExtender MinimumPrefixLength="1" runat="server" 
   ServiceMethod="GetTitleSuggestions" ServicePath="BookService.asmx" >

   <atlas:AutoCompleteProperties TargetControlID="txtSearch" Enabled="true" />
</atlas:AutoCompleteExtender>


 *  
 * alternatywa z uyciem kodu po stronie klienta
 * 
      <script type="text/xml-script">
         <page xmlns:script="http://schemas.microsoft.com/xml-script/2005">
            <components>
               <textBox id="txtSearch">
                  <behaviors>
                     <autoComplete 
                        completionList="drpSearchDiv"
                        serviceURL="BookService.asmx" 
                        serviceMethod="GetTitleSuggestions"
                        minimumPrefixLength="1" 
                        completionSetCount="8" 
                        completionInterval="200" />
                  </behaviors>
               </textBox>
            </components>
         </page>
      </script>
*/