﻿using Microsoft.AspNetCore.Http;
using System.Linq;
using System.Threading.Tasks;
using WebApp.Models;

namespace WebApp
{
    public class TestMiddleware
    {
        private RequestDelegate nextDelegate;
        public TestMiddleware(RequestDelegate next)
        {
            nextDelegate = next;
        }

        public async Task Invoke(HttpContext context, DataContext dataContext)
        {
            if (context.Request.Path == "/test")
            {
                await context.Response.WriteAsync(
                    $"Liczba produktów: {dataContext.Products.Count()}\n");
                await context.Response.WriteAsync(
                    $"Liczba kategorii: {dataContext.Categories.Count()}\n");
                await context.Response.WriteAsync(
                    $"Liczba dostawców: {dataContext.Suppliers.Count()}\n");
            }
            else
            {
                await nextDelegate(context);
            }
        }
    }
}