﻿using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;

namespace Platform.Services
{
    public class HtmlResponseFormatter : IResponseFormatter
    {
        public async Task Format(HttpContext context, string content)
        {
            context.Response.ContentType = "text/html";
            await context.Response.WriteAsync($@"
                <!DOCTYPE html>
                <html lang=""pl"">
                <head><title>Wynik sformatowany</title></head>
                <body>
                    <h2>Wynik sformatowany</h2>
                    <span>{content}</span>
                </body>
                </html>");
        }
        public bool RichOutput => true;
    }
}