﻿using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;

namespace Platform.Services
{
    public class TimeResponseFormatter : IResponseFormatter
    {
        private ITimeStamper stamper;
        public TimeResponseFormatter(ITimeStamper timeStamper)
        {
            stamper = timeStamper;
        }
        public async Task Format(HttpContext context, string content)
        {
            await context.Response.WriteAsync($"{stamper.TimeStamp}: {content}");
        }
    }
}