using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.AspNetCore.Routing;

namespace Platform
{
    public class Startup
    {
        public void ConfigureServices(IServiceCollection services)
        {
            services.Configure<RouteOptions>(opts => {
                opts.ConstraintMap.Add("countryName",
                    typeof(CountryRouteConstraint));
            });
        }
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            app.UseDeveloperExceptionPage();
            app.UseRouting();

            app.Use(async (context, next) => {
                Endpoint end = context.GetEndpoint();
                if (end != null)
                {
                    await context.Response
                        .WriteAsync($"wybrana trasa to {end.DisplayName} \n");
                }
                else
                {
                    await context.Response.WriteAsync("brak wybranej trasy \n");
                }
                await next();
            });

            app.UseEndpoints(endpoints => {
                endpoints.Map("{number:int}", async context => {
                    await context.Response.WriteAsync("przekierowanie do trasy int");
                })
                .WithDisplayName("int")
                .Add(b => ((RouteEndpointBuilder)b).Order = 1);
                endpoints.Map("{number:double}", async context => {
                    await context.Response
                        .WriteAsync("przekierowanie do trasy double");
                })
                .WithDisplayName("double")
                .Add(b => ((RouteEndpointBuilder)b).Order = 2);
            });

            app.Use(async (context, next) => {
                await context.Response.WriteAsync("ostatni wykonywany komponent potoku");
            });
        }
    }
}
