using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.AspNetCore.Routing;
using Platform.Services;
using Microsoft.Extensions.Configuration;
using System;
using System.Linq;
using System.Collections.Generic;

namespace Platform
{
    public class Startup
    {
        public Startup(IConfiguration config)
        {
            Configuration = config;
        }
        
        private IConfiguration Configuration;

        public void ConfigureServices(IServiceCollection services)
        {
            services.AddSingleton(typeof(ICollection<>), typeof(List<>));
        }

        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            {
                app.UseDeveloperExceptionPage();
                app.UseRouting();
                app.UseEndpoints(endpoints => {
                    endpoints.MapGet("/string", async context => {
                        ICollection<string> collection
                            = context.RequestServices.GetService<ICollection<string>>();
                        collection.Add($"godzina: { DateTime.Now.ToLongTimeString() }");
                        foreach (string str in collection)
                        {
                            await context.Response.WriteAsync($"tekst: {str}\n");
                        }
                    });
                    endpoints.MapGet("/int", async context => {
                        ICollection<int> collection
                            = context.RequestServices.GetService<ICollection<int>>();
                        collection.Add(collection.Count() + 1);
                        foreach (int val in collection)
                        {
                            await context.Response.WriteAsync($"int: {val}\n");
                        }
                    });
                });
            }
        }
    }
}