﻿using System;
using Microsoft.AspNetCore.Mvc;
using ModelValidation.Models;
using Microsoft.AspNetCore.Mvc.ModelBinding;

namespace ModelValidation.Controllers
{
    public class HomeController : Controller
    {
        public IActionResult Index() =>
            View("MakeBooking", new Appointment { Date = DateTime.Now });

        [HttpPost]
        public ViewResult MakeBooking(Appointment appt)
        {
            if (ModelState.GetValidationState(nameof(appt.Date))
                    == ModelValidationState.Valid
                && ModelState.GetValidationState(nameof(appt.ClientName))
                    == ModelValidationState.Valid
                && appt.ClientName.Equals("Janek", StringComparison.OrdinalIgnoreCase)
                && appt.Date.DayOfWeek == DayOfWeek.Monday)
            {
                ModelState.AddModelError("",
                    "Janek nie może rezerwować wizyt w poniedziałki.");
            }

            if (ModelState.IsValid)
            {
                return View("Completed", appt);
            }
            else
            {
                return View();
            }
        }

        public JsonResult ValidateDate(string Date)
        {
            DateTime parsedDate;

            if (!DateTime.TryParse(Date, out parsedDate))
            {
                return Json("Proszę podać prawidłową datę (dd.mm.rrrr).");
            }
            else if (DateTime.Now > parsedDate)
            {
                return Json("Proszę podać datę w przyszłości.");
            }
            else
            {
                return Json(true);
            }
        }
    }
}