﻿using Microsoft.AspNetCore.Razor.TagHelpers;

namespace AlertTagHelper.TagHelpers
{
    [HtmlTargetElement("alert")]
    public class AlertSimpleTagHelper : TagHelper
    {
        [HtmlAttributeName("type")]
        public string AlertType { get; set; }
        public override void Process(TagHelperContext context, TagHelperOutput output)
        {
            output.TagName = "div";
            var cssClass = "alert alert-" + AlertType;
            output.Attributes.Add("class", cssClass);
            output.Attributes.Add("role", "alert");
        }
    }
}
