﻿using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;
using Angular.Models;
using Newtonsoft.Json;

namespace Angular.Controllers
{
    [Route("api/[controller]")]
    public class AthletesController : Controller
    {
        // GET: api/values
        [HttpGet]
        public AthletesViewModel Get()
        {
            return new AthletesViewModel(new[] {
                new Athlete("Jan Frodeno", "Niemcy", "08:06:30"),
                new Athlete("Sebastian Kienle", "Niemcy", "08:10:02"),
                new Athlete("Patrick Lange", "Niemcy", "08:11:14"),
                new Athlete("Ben Hoffman", "USA", "08:13:00"),
                new Athlete("Andi Boecherer", "Niemcy", "08:13:25")
            });
        }
    }

    public class AthletesViewModel
    {
        public AthletesViewModel(IEnumerable<Athlete> items)
        {
            Items = items;
        }
        [JsonProperty(PropertyName = "data")]
        public IEnumerable<Athlete> Items { get; set; }
    }
}
