﻿import { Component, Output, EventEmitter, OnInit } from '@angular/core';
import { AthleteService } from './athlete.service';
import { Athlete } from "./athlete";
import { TimingPoint } from "./TimingPoint";
import { Observable } from "rxjs/Observable";


@Component({
    selector: 'results-list',
    templateUrl: 'results-list.component.html'
})
export class ResultsListComponent implements OnInit {
    athletes: Athlete[];
    timingPoints: TimingPoint[];
    @Output() selected = new EventEmitter<Athlete>();
    constructor(private athleteService: AthleteService) { }

    getAthletes() {
        this.athleteService.getAthletes()
            .then(list => {
                for (var i = 0; i < list.length; i++) {
                    var athlete = list[i];
                    athlete.timingValues = new Map<string, string>();
                    for (var j = 0; j < athlete.timings.length; j++) {
                        athlete.timingValues.set(athlete.timings[j].code, athlete.timings[j].time);
                    }
                }
                this.athletes = list;
            });
    }

    getTimingPoints() {
        this.athleteService.getTimingPoints()
            .then(list => this.timingPoints = list);
    }

    ngOnInit() {
        this.getAthletes();
        this.getTimingPoints();
    }

    select(selectedAthlete: Athlete) {
        this.selected.emit(selectedAthlete);
    }
}