﻿using Microsoft.EntityFrameworkCore;
using TriathlonRaceTracking.Models;

namespace TriathlonRaceTracking.Data
{
    public class TriathlonRaceTrackingContext : DbContext
    {
        public TriathlonRaceTrackingContext (DbContextOptions<TriathlonRaceTrackingContext> options)
            : base(options)
        {
        }

        public DbSet<Race> Races { get; set; }

        public DbSet<TimingPoint> TimingPoints { get; set; }
        public DbSet<Athlete> Athletes { get; set; }
        public DbSet<Registration> Registrations { get; set; }

        public DbSet<Timing> Timings { get; set; }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Race>().ToTable("Race");
            modelBuilder.Entity<TimingPoint>().ToTable("TimingPoint");
            modelBuilder.Entity<Athlete>().ToTable("Athlete");
            modelBuilder.Entity<Registration>().ToTable("Registration");
            modelBuilder.Entity<Timing>().ToTable("Timing");

            modelBuilder.Entity<Timing>()
                .HasOne(t => t.TimingPoint)
                .WithMany(t => t.Timings)
                .OnDelete(DeleteBehavior.Restrict);
        }
    }
}
