using Frontend.Services;
using Frontend.ViewModels;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using TriathlonRaceTracking.Data;

namespace Frontend.Controllers
{
    [Route("api/[controller]")]
    public class StandingsController : Controller
    {

        private readonly ITimingService _service;

        public StandingsController(ITimingService service)
        {
            _service = service;
        }

        // GET: api/values
        [HttpGet]
        public AthletesViewModel Get()
        {
            var data = _service.GetStandings(1);

            var model = new AthletesViewModel(data);
            return model;
        }
    }
}