import React, { Component } from 'react';

class Greeter extends React.Component {
  constructor(props) {
    super(props);
    this.state = {firstName: props.firstName, lastName: props.lastName};

    this.handleFirstNameChange = this.handleFirstNameChange.bind(this);
    this.handleLastNameChange = this.handleLastNameChange.bind(this);
  }

  handleFirstNameChange(event) {
    this.setState({firstName: event.target.value}); 
  }
  
  handleLastNameChange(event) {
    this.setState({lastName: event.target.value});
  }

  render() {
    return (
      <div>
      <form>
        <div>
          <label>
            Imię:
            <input type="text" value={this.state.firstName} onChange={this.handleFirstNameChange} />
          </label>
        </div>
        <div>
          <label>
            Nazwisko:
            <input type="text" value={this.state.lastName} onChange={this.handleLastNameChange} />
          </label>
        </div>
      </form>
      <hr/>
      <h1>Witaj, <span>{this.state.firstName} {this.state.lastName}</span>!</h1>
      </div>
    );
  }
}

export default Greeter;
