﻿using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using TriathlonRaceTracking.Data;

namespace TriathlonRaceTracking.Models
{
    public static class InitialData
    {
        public static async Task InitializeAsync(IServiceProvider service)
        {
            using (var serviceScope = service.CreateScope())
            {
                var scopeServiceProvider = serviceScope.ServiceProvider;
                var db = scopeServiceProvider.GetService<TriathlonRaceTrackingContext>();
                db.Database.Migrate();
                await InsertTestData(db);
            }
        }

        private static  async Task InsertTestData(TriathlonRaceTrackingContext context)
        {
            if(context.Races.Any())
                return;
            var race = new Race { Name="Ironman World Championship 2017",Location="Kona, Hawaii",Date=new DateTime(2017,10,14,7,0,0) };

            var timingPoints = new List<TimingPoint>
            {
                new TimingPoint{ Race=race, Name="Start", Type=TimingType.Start,Code="START"},
                new TimingPoint{ Race=race, Name="Stairs", Type=TimingType.SwimEnd,Code="T1S"},
                new TimingPoint{ Race=race, Name="T1 Exit", Type=TimingType.BikeStart,Code="T1E"},
                new TimingPoint{ Race=race, Name="Turnaround", Type=TimingType.Intermediate,Code="BikeMid"},
                new TimingPoint{ Race=race, Name="T2 Entrance", Type=TimingType.BikeEnd,Code="T2S"},
                new TimingPoint{ Race=race, Name="T2 Exit", Type=TimingType.RunStart,Code="T2E"},
                new TimingPoint{ Race=race, Name="End", Type=TimingType.End,Code="End"}
            };

            var athletes = new List<Athlete>
            {
                new Athlete{  FirstName="Patrick", LastName="Lange", Nationality="Niemcy" },
                new Athlete{  FirstName="Lionel", LastName="Sanders", Nationality="Kanada" },
                new Athlete{  FirstName="David", LastName="Mcnamee", Nationality="Wielka Brytania" },
                new Athlete{  FirstName="Sebastien", LastName="Kienle", Nationality="Niemcy" },
                new Athlete{  FirstName="James", LastName="Cunnama", Nationality="RPA" },
                new Athlete{  FirstName="Terenzo", LastName="Bozzone", Nationality="Nowa Zelandia" }
            };

            var startlist = new List<Registration>
            {
                new Registration{ BibNumber=5,Race=race, Athlete = athletes.SingleOrDefault(a=>a.LastName.Equals("Lange")),
                    Timings = new List<Timing>
                    {
                        new Timing{ Time=new DateTime(2017,10,14,7,0,0),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.Start) },
                        new Timing{ Time=new DateTime(2017,10,14,7,48,45),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.SwimEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,7,50,34),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeStart) },
                        new Timing{ Time=new DateTime(2017,10,14,12,19,27),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,12,21,41),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.RunStart) },
                        new Timing{ Time=new DateTime(2017,10,14,15,1,40),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.End) }
                    }
                },
                new Registration{ BibNumber=30,Race=race, Athlete = athletes.SingleOrDefault(a=>a.LastName.Equals("Sanders")),
                    Timings = new List<Timing>
                    {
                        new Timing{ Time=new DateTime(2017,10,14,7,0,0),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.Start) },
                        new Timing{ Time=new DateTime(2017,10,14,7,53,41),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.SwimEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,7,55,39),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeStart) },
                        new Timing{ Time=new DateTime(2017,10,14,12,09,58),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,12,12,14),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.RunStart) },
                        new Timing{ Time=new DateTime(2017,10,14,15,04,7),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.End) }
                    }
                },
                new Registration{ BibNumber=16,Race=race, Athlete = athletes.SingleOrDefault(a=>a.LastName.Equals("Mcnamee")),
                    Timings = new List<Timing>
                    {
                        new Timing{ Time=new DateTime(2017,10,14,7,0,0),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.Start) },
                        new Timing{ Time=new DateTime(2017,10,14,7,48,40),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.SwimEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,7,50,43),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeStart) },
                        new Timing{ Time=new DateTime(2017,10,14,12,19,38),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,12,21,41),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.RunStart) },
                        new Timing{ Time=new DateTime(2017,10,14,15,7,11),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.End) }
                    }
                },
                new Registration{ BibNumber=2,Race=race, Athlete = athletes.SingleOrDefault(a=>a.LastName.Equals("Kienle")),
                    Timings = new List<Timing>
                    {
                        new Timing{ Time=new DateTime(2017,10,14,7,0,0),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.Start) },
                        new Timing{ Time=new DateTime(2017,10,14,7,53,44),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.SwimEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,7,55,42),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeStart) },
                        new Timing{ Time=new DateTime(2017,10,14,12,10,39),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,12,12,48),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.RunStart) },
                        new Timing{ Time=new DateTime(2017,10,14,15,9,59),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.End) }
                    }
                },
                new Registration{ BibNumber=19,Race=race, Athlete = athletes.SingleOrDefault(a=>a.LastName.Equals("Cunnama")),
                    Timings = new List<Timing>
                    {
                        new Timing{ Time=new DateTime(2017,10,14,7,0,0),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.Start) },
                        new Timing{ Time=new DateTime(2017,10,14,7,49,09),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.SwimEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,7,51,20),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeStart) },
                        new Timing{ Time=new DateTime(2017,10,14,12,12,22),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,12,14,38),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.RunStart) },
                        new Timing{ Time=new DateTime(2017,10,14,15,11,24),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.End) }
                    }
                },
                new Registration{ BibNumber=15,Race=race, Athlete = athletes.SingleOrDefault(a=>a.LastName.Equals("Bozzone")),
                    Timings = new List<Timing>
                    {
                        new Timing{ Time=new DateTime(2017,10,14,7,0,0),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.Start) },
                        new Timing{ Time=new DateTime(2017,10,14,7,48,41),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.SwimEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,7,50,39),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeStart) },
                        new Timing{ Time=new DateTime(2017,10,14,12,16,59),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.BikeEnd) },
                        new Timing{ Time=new DateTime(2017,10,14,12,19,19),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.RunStart) },
                        new Timing{ Time=new DateTime(2017,10,14,15,13,6),TimingPoint=timingPoints.SingleOrDefault(tp=>tp.Type==TimingType.End) }
                    }
                }
            };


            context.Add(race);
            context.AddRange(timingPoints);
            context.AddRange(athletes);
            context.AddRange(startlist);
            await context.SaveChangesAsync();
        }
    }
}
