<%@ Page Language="VB" MasterPageFile="~/MasterPage.master" AutoEventWireup="false" 
	CodeFile="Cart.aspx.vb" Inherits="Cart" title="Koszyk na zakupy" %>
<%@ MasterType TypeName="MasterPage" %>	
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" 
		Runat="Server">
	<asp:SqlDataSource ID="sqlCart" runat="server" 
		ConnectionString="<%$ ConnectionStrings:AdventureWorksConnectionString %>"  
		SelectCommand= "select product.ProductID, product.Name, product.ProductNumber, 
					product.Color,	
					subcat.Name as SubcategoryName, cat.Name as CategoryName,
					description.Description 
					from Production.Product product 
					join Production.ProductSubcategory subcat on 
						product.ProductSubcategoryID = subcat.ProductSubcategoryID 
					join Production.ProductCategory cat on 
						subcat.ProductCategoryID = cat.ProductCategoryID 
					join Production.ProductModel model on 
						product.ProductModelID = model.ProductModelID 
					join Production.ProductModelProductDescriptionCulture culture on 
						model.ProductModelID = culture.ProductModelID 
					join Production.ProductDescription description on 
						culture.ProductDescriptionID = description.ProductDescriptionID ">
	</asp:SqlDataSource>					
	<asp:GridView ID="gvCart" runat="server" 
			DataSourceID="sqlCart"
			AllowPaging="True" AllowSorting="True" Width="100%"
			AutoGenerateColumns="False" 
			HeaderStyle-CssClass="TableColumnHeading" 
			RowStyle-CssClass="TableCells">
		<Columns>
			<asp:CommandField ShowSelectButton="True" SelectText="Usu" CancelText="Anuluj" DeleteText="Usu" EditText="Edycja" InsertText="Wstaw" NewText="Nowy" UpdateText="Zmie">
                <ItemStyle HorizontalAlign="Center" Width="50px" />
                <ControlStyle CssClass="ButtonSelect" />
            </asp:CommandField>
			<asp:BoundField DataField="ProductID" HeaderText="Identyfikator">
                <ItemStyle Width="50px" />
            </asp:BoundField>
			<asp:BoundField DataField="ProductNumber" HeaderText="Numer produktu" >
                <ItemStyle Width="90px" />
            </asp:BoundField>
			<asp:BoundField DataField="Color" HeaderText="Kolor" >
                <ItemStyle Width="60px" />
            </asp:BoundField>
			<asp:BoundField DataField="CategoryName" HeaderText="Kategoria" >
                <ItemStyle Width="75px" />
            </asp:BoundField>
			<asp:BoundField DataField="SubcategoryName" HeaderText="Podkategoria" >
                <ItemStyle Width="75px" />
            </asp:BoundField>
			<asp:BoundField DataField="Description" HeaderText="Opis"  />
		</Columns>
        <RowStyle CssClass="TableCells" />
        <HeaderStyle CssClass="TableColumnHeading" />
	</asp:GridView>
	<br />
	<asp:Button ID="btnPurchase" runat="server" Text="Kupuj produkty w koszyku" 
				CssClass="ButtonText"/>

</asp:Content>

