﻿<%@ Page Language="VB" AutoEventWireup="true" CodeFile="OrderForm.aspx.vb" Inherits="_Default" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
	<style type="text/css">@import url(StyleSheet.css);</style>
    <title>AdventureWorks CollapsiblePanelExtender</title>
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server" />
        <div>
        <h1>AdventureWorks Order Form</h1>
            <table>
                <tr>
                    <td style="width: 100px">
                        Customer Name:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtName" runat="server" 
							CssClass="unwatermarked">
						</asp:TextBox>
						<cc1:TextBoxWatermarkExtender runat="server" 
							ID="CustomerNameWatermark" 
							TargetControlID="txtName"
							WatermarkCssClass="watermarked"
							WatermarkText="Your name">
						</cc1:TextBoxWatermarkExtender>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        Address:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtAddress" runat="server" 
							CssClass="unwatermarked"></asp:TextBox>
						<cc1:TextBoxWatermarkExtender runat="server" 
								ID="CustomerAddressWatermark" 
								TargetControlID="txtAddress"
								WatermarkCssClass="watermarked"
								WatermarkText="Home address">
						</cc1:TextBoxWatermarkExtender>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        City:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtCity" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        State:</td>
                    <td style="width: 100px">
                        <asp:DropDownList ID="ddlState" runat="server">
                            <asp:ListItem Value="AL">Alabama</asp:ListItem>
                            <asp:ListItem Value="AK">Alaska</asp:ListItem>
                            <asp:ListItem Value="CA">California</asp:ListItem>
                            <asp:ListItem Value="CT">Connecticut</asp:ListItem>
                            <asp:ListItem Value="FL">Florida</asp:ListItem>
                            <asp:ListItem Value="PA">Pennsylvania</asp:ListItem>
                            <asp:ListItem Value="TX">Texas</asp:ListItem>
                            <asp:ListItem></asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        Zip:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtZip" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        E-mail:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtEmail" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        Password:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtPassword" runat="server" 
								TextMode="Password"></asp:TextBox></td>
                </tr>
                <tr>
                    <td style="width: 100px">
                        Comment:</td>
                    <td style="width: 100px">
                        <asp:TextBox ID="txtComment" runat="server" Rows="3" 
								TextMode="MultiLine" Width="300px"></asp:TextBox>
					</td>
                </tr>
            </table>
        </div>
		<asp:UpdatePanel ID="UpdatePanel1" runat="server">
			<ContentTemplate>
        Provide personal information:
        <asp:RadioButton ID="rbYes" runat="server" AutoPostBack="True" 
			Checked="True" 
            GroupName="grpPersonalInfo"
            Text="Yes" ToolTip="Do gather personal info" />
        <asp:RadioButton ID="rbNo" runat="server" AutoPostBack="True" 
            GroupName="grpPersonalInfo"
            Text="No" ToolTip="Do not gather personal info" /><br />
        <asp:Panel ID="pnlPersonalInfo" runat="server" 
			Height="50px" Width="125px" BorderWidth="1px">
            <table>
                <tr valign="top">
                    <td >
                        Areas of Interest<br />
                        <asp:CheckBoxList ID="cblAreas" runat="server" 
								AutoPostBack="True" Width="150px">
                            <asp:ListItem>Biking</asp:ListItem>
                            <asp:ListItem>Scuba Diving</asp:ListItem>
                            <asp:ListItem>Gaming</asp:ListItem>
                            <asp:ListItem>Mountain Climbing</asp:ListItem>
                            <asp:ListItem>Web Surfing</asp:ListItem>
                            <asp:ListItem>Real Surfing</asp:ListItem>
                        </asp:CheckBoxList></td>
                    <td style="width: 10521px">
                        Age Category&nbsp;<br />
						<asp:TextBox ID="txtAgeCategory" runat="server" Width="175px">
						</asp:TextBox>

						<cc1:TextBoxWatermarkExtender ID="TextBoxWatermarkExtender1" runat="server" 
							TargetControlID="txtAgeCategory" 
							WatermarkText="Click here for age categories">
						</cc1:TextBoxWatermarkExtender>
						<cc1:PopupControlExtender ID="PopupControlExtender1" runat="server" 
							TargetControlID="txtAgeCategory" 
							PopupControlID="pnlAgeCategories" 
							Position="Bottom">
						</cc1:PopupControlExtender>
						<asp:Panel ID="pnlAgeCategories" runat="server" Height="50px" 
							Width="125px">
							<asp:UpdatePanel ID="UpdatePanel2" runat="server">
								<ContentTemplate>
						<asp:RadioButtonList ID="rblAge" runat="server" 
								AutoPostBack="True" Width="125px" 
								OnSelectedIndexChanged="rblAge_SelectedIndexChanged">
							<asp:ListItem Value="Under 21 - Enjoy it!">Under 21
									</asp:ListItem>
							<asp:ListItem Value="21 to 30 - Livin' Large">21 to 30
									</asp:ListItem>
							<asp:ListItem Value="31 to 50 - Life Is Good">31 to 50
									</asp:ListItem>
							<asp:ListItem Value="Over 50 - Golden Years">Over 50
									</asp:ListItem>
						</asp:RadioButtonList>
								</ContentTemplate>
							</asp:UpdatePanel>
						</asp:Panel>
					</td>
                </tr>
            </table>
        </asp:Panel>
			</ContentTemplate>
		</asp:UpdatePanel>
        <br />
		<asp:Panel ID="pnlProductInfoHeader" runat="server" Height="50px" Width="125px">
			<asp:Image ID="imgProductInfo_ToggleImage" runat="server" 
				ImageUrl="~/collapse.jpg" /><br />
			Product Information</asp:Panel>
		<asp:Panel ID="pnlProductInfo" runat="server" BackColor="LightGray" 
			Height="50px" Width="450px">
			<asp:Label ID="myLabel" runat="server" Text=
			"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. 
   Aliquam eleifend, turpis sit amet tincidunt euismod, urna eros mattis 
   neque, vitae facilisis nulla dui ut dolor. Proin pretium. Etiam ultrices 
   eleifend neque. Mauris vestibulum purus quis nibh. Phasellus dignissim. 
   Vivamus laoreet magna id purus. In hac habitasse platea dictumst. Vivamus 
   congue elit quis arcu. Sed lorem mauris, convallis non, porta sed, interdum 
   id, nisl. Aenean id tortor. Sed ac quam. Suspendisse ornare luctus sapien. 
   Praesent aliquet, lacus nec venenatis placerat, massa metus mattis dolor,
   non eleifend pede sapien et lorem. Curabitur dapibus faucibus nunc.">
			</asp:Label>
			<br />
			<br />
			<asp:Image ID="Image1" runat="server" ImageUrl="Dan at Vernal Pool.jpg" />
		</asp:Panel>
		<cc1:CollapsiblePanelExtender ID="cpeProductInfo" runat="server" 
			CollapseControlID="pnlProductInfoHeader" 
			Collapsed="true" 
			CollapsedImage="collapse.jpg" 
			CollapsedText="Product Information (Show Details...)" 
			ExpandControlID="pnlProductInfoHeader" 
			ExpandedImage="expand.jpg" 
			ExpandedText="Product  Information (Hide Details...)" 
			ImageControlID="imgProductInfo_ToggleImage" 
			SuppressPostBack="true" 
			TargetControlID="pnlProductInfo">
		</cc1:CollapsiblePanelExtender>

    </form>
</body>
</html>
