<%@ Page Language="VB" MasterPageFile="~/MasterPage.master" AutoEventWireup="false" 
	CodeFile="Purchase.aspx.vb" Inherits="Purchase" title="Zakup produktw" %>
<%@ MasterType TypeName="MasterPage" %>	
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" 
		Runat="Server">
	<table border="0" class="TableRowHeading">
		<tr>
			<td colspan="4">
                Informacje dla celw zamwienia</td>
		</tr>
		<tr>
			<td>
                Imi i nazwisko</td>
			<td colspan="4">
				<asp:TextBox ID="txtName" runat="server" Width="250" />
				<asp:RequiredFieldValidator ID="rfName" runat="server" 
					ControlToValidate="txtName"
					Display="Dynamic" ErrorMessage="Imi i nazwisko jest wymagane." 
					CssClass="ValidationError">*</asp:RequiredFieldValidator></td>
		</tr>
		<tr>
			<td>
                Adres</td>
			<td colspan="3">
				<asp:TextBox ID="txtAddress" runat="server" Width="250" />
				<asp:RequiredFieldValidator ID="rfAddress" runat="server" 
					ControlToValidate="txtAddress"
					Display="Dynamic" ErrorMessage="Adres jest wymagany."
					CssClass="ValidationError">*</asp:RequiredFieldValidator></td>
		</tr>
		<tr>
			<td>
                Miasto</td>
			<td style="width: 181px">
				<asp:TextBox ID="txtCity" runat="server" />
				<asp:RequiredFieldValidator ID="rfCity" runat="server" 
					ControlToValidate="txtCity"
					Display="Dynamic" ErrorMessage="Miasto jest wymagane."
					CssClass="ValidationError">*</asp:RequiredFieldValidator>
			</td>
			<td>
				<asp:SqlDataSource ID="sqlStates" runat="server" 
					ConnectionString=
						"<%$ ConnectionStrings:AdventureWorksConnectionString %>" 
					SelectCommand="SELECT StateProvinceCode, [Name] 
							FROM Person.StateProvince 
							WHERE CountryRegionCode = 'US' order by [Name]">
				</asp:SqlDataSource>
				<asp:DropDownList ID="ddlStates" runat="server" 
					DataSourceID="sqlStates" 
					DataTextField="Name" DataValueField="StateProvinceCode" />
			</td>
		</tr>
		<tr>
			<td>
                Kod pocztowy</td>
			<td style="width: 181px">
				<asp:TextBox ID="txtZip" runat="server" />
				<asp:RequiredFieldValidator ID="rfZip" runat="server" 
					ControlToValidate="txtZip"
					Display="Dynamic" ErrorMessage="Kod pocztowy jest wymagany."
					CssClass="ValidationError">*</asp:RequiredFieldValidator>
				<asp:RegularExpressionValidator ID="reZip" runat="server" 
					ErrorMessage="Nieprawidowy kod pocztowy."
					ControlToValidate="txtZip"
					Display="Dynamic"
					ValidationExpression="^\d{5}$|^\d{5}-\d{4}$"
					CssClass="ValidationError">*</asp:RegularExpressionValidator>	
			</td>
		</tr>
		<tr>
			<td>
                Karta kredytowa</td>
			<td colspan="3" >
				<asp:RadioButtonList ID="rblCardType" runat="server" 
						RepeatDirection="Horizontal">
					<asp:ListItem Value="am" Text="American Express" />
 					<asp:ListItem Value="d" Text="Discover" />
					<asp:ListItem Value="mc" Text="MasterCard" />
					<asp:ListItem Value="v" Text="Visa" />
				</asp:RadioButtonList>
				<asp:RequiredFieldValidator ID="rfCreditCard" runat="server" 
					ErrorMessage="Nie wskazano rodzaju karty kredytowej." 
					ControlToValidate="rblCardType" Display="Dynamic"
					InitialValue=""
					CssClass="ValidationError">*</asp:RequiredFieldValidator>
			</td>
		</tr>
		<tr>
			<td>
                Nr karty</td>
			<td style="width: 181px">
				<asp:TextBox ID="txtCCNumber" runat="server" />
				<asp:RequiredFieldValidator ID="rfCCNumber" runat="server" 
					ControlToValidate="txtCCNumber"
					Display="Dynamic" 
					ErrorMessage="Numer karty kredytowej jest wymagany."
					CssClass="ValidationError">*</asp:RequiredFieldValidator>
				<asp:RegularExpressionValidator ID="reCCNumber" runat="server" 
					ErrorMessage="Nieprawidowy numer karty kredytowej."
					ControlToValidate="txtCCNumber"
					Display="Dynamic"
					ValidationExpression=
						"^(\d{4}-){3}\d{4}$|^(\d{4} ){3}\d{4}$|^\d{16}$"
					CssClass="ValidationError">*</asp:RegularExpressionValidator>	
			</td>
			<td align="right">
                Kod bezpieczestwa</td>
			<td>
				<asp:TextBox ID="txtSecurityCode" runat="server" />
				<asp:RequiredFieldValidator ID="rfSecurityCode" runat="server" 
					ControlToValidate="txtSecurityCode"
					Display="Dynamic" 
					ErrorMessage="Kod bezpieczestwa jest wymagany."
					CssClass="ValidationError">*</asp:RequiredFieldValidator>
				<asp:RegularExpressionValidator ID="reSecurityCode" 
					runat="server" 
					ErrorMessage="Nieprawidowy kod bezpieczestwa."
					ControlToValidate="txtSecurityCode"
					Display="Dynamic"
					ValidationExpression="^\d{3}$"
					CssClass="ValidationError">*</asp:RegularExpressionValidator>	
			</td>
		</tr>
		<tr>
			<td colspan="2">
                Informacje dla celw wysyki&nbsp;</td>
			<td colspan="2">
				<asp:RadioButtonList ID="rblShippingAddress" runat="server" 
					AutoPostBack="true" RepeatDirection="Horizontal">
					<asp:ListItem Value="billing" Text="Wysyka na adres z zam&#243;wienia" 
							Selected="True" />
					<asp:ListItem Value="different" 
							Text="Wysyka na inny adres" />
				</asp:RadioButtonList>
			</td>
		</tr>
		<tr>
			<td colspan="4">
				<asp:Panel ID="pnlShippingAddress" runat="server" Visible="false" >
					<table border="0">
						<tr>
							<td>
                                Adres</td>
							<td colspan="3">
								<asp:TextBox ID="txtShippingAddress" runat="server" 
										Width="250" />
							</td>
						</tr>
						<tr>
							<td>
                                Miasto</td>
							<td>
								<asp:TextBox ID="txtShippingCity" runat="server" />
							</td>
							<td>
								<asp:DropDownList ID="ddlShippingStates" 
									runat="server" 
									DataSourceID="sqlStates" 
									DataTextField="Name" 
									DataValueField="StateProvinceCode" />
							</td>
							<td>
                                Kod pocztowy</td>
							<td>
								<asp:TextBox ID="txtShippingZip" runat="server" />
								<asp:RegularExpressionValidator ID="reShippingZip" 
									runat="server" 
									ErrorMessage="Nieprawidowy kod pocztowy"
									ControlToValidate="txtShippingZip"
									Display="Dynamic"
									ValidationExpression="^\d{5}$|^\d{5}-\d{4}$"
									CssClass="ValidationError">*
								</asp:RegularExpressionValidator>	
							</td>
						</tr>
					</table>
				</asp:Panel>
			</td>
		</tr>
		<tr>
			<td colspan="4">
				<asp:ValidationSummary ID="ValidationSummary1" runat="server" 
					CssClass="ValidationError" />
			</td>
		</tr>
		<tr>
			<td colspan="4">
				<asp:Button ID="btnBuy" runat="server" Text="Kupuj" 
					CssClass="ButtonText" />
			</td>
		</tr>
	</table>
		
</asp:Content>

