﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using ControllersAndActions.Controllers;
using System.Web.Mvc;

namespace ControllersAndActions.Tests {
    [TestClass]
    public class ActionTests {

        [TestMethod]
        public void ViewSelectionTest() {

            // przygotowanie - utworzenie kontrolera
            ExampleController target = new ExampleController();

            // działanie — wywołanie metody akcji
            ViewResult result = target.Index();

            // asercje — sprawdzenie wyniku
            Assert.AreEqual("Witaj", result.ViewBag.Message);
        }

        [TestMethod]
        public void RedirectTest() {
            // przygotowanie - utworzenie kontrolera
            ExampleController target = new ExampleController();

            // działanie — wywołanie metody akcji
            RedirectResult result = target.Redirect();

            // asercje — sprawdzenie wyniku
            Assert.IsTrue(result.Permanent);
            Assert.AreEqual("/Example/Index", result.Url);
        }

        [TestMethod]
        public void RedirectValueTest() {

            // przygotowanie - utworzenie kontrolera
            ExampleController target = new ExampleController();

            // działanie — wywołanie metody akcji
            RedirectToRouteResult result = target.RedirectToRoute();

            // asercje — sprawdzenie wyniku
            Assert.IsFalse(result.Permanent);    

            Assert.AreEqual("Example", result.RouteValues["controller"]);
            Assert.AreEqual("Index", result.RouteValues["action"]);
            Assert.AreEqual("MyID", result.RouteValues["ID"]);
        }

        [TestMethod]
        public void StatusCodeResultTest() {

            // przygotowanie - utworzenie kontrolera
            ExampleController target = new ExampleController();

            // działanie — wywołanie metody akcji
            HttpStatusCodeResult result = target.StatusCode();

            // asercje — sprawdzenie wyniku
            Assert.AreEqual(401, result.StatusCode);
        }
    }
}