﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using TheMVCPattern.Controllers;
using TheMVCPattern.Models;

namespace TheMVCPattern.Tests {


    [TestClass()]
    public class AdminControllerTest {


        private TestContext testContextInstance;

        public TestContext TestContext {
            get {
                return testContextInstance;
            }
            set {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion



        [TestMethod]
        public void CanChangeLoginName() {

            // przygotowanie (skonfigurowanie scenariusza)
            Member bob = new Member() { LoginName = "Bogdan" };
            FakeMembersRepository repositoryParam = new FakeMembersRepository();
            repositoryParam.Members.Add(bob);
            AdminController target = new AdminController(repositoryParam);
            string oldLoginParam = bob.LoginName;
            string newLoginParam = "Anastazja";

            // działanie (wykonanie operacji)
            target.ChangeLoginName(oldLoginParam, newLoginParam);

            // asercje (weryfikacja wyniku)
            Assert.AreEqual(newLoginParam, bob.LoginName);
            Assert.IsTrue(repositoryParam.DidSubmitChanges);
        }

        private class FakeMembersRepository : IMembersRepository {
            public List<Member> Members = new List<Member>();
            public bool DidSubmitChanges = false;

            public void AddMember(Member member) {
                throw new NotImplementedException();
            }

            public Member FetchByLoginName(string loginName) {
                return Members.First(m => m.LoginName == loginName);
            }

            public void SubmitChanges() {
                DidSubmitChanges = true;
            }
        }

        [TestMethod()]
        public void CanAddBid() {

            // przygotowanie - skonfigurowanie scenariusza
            Item target = new Item();
            Member memberParam = new Member();
            Decimal amountParam = 150M;

            // działanie - wykonanie operacji
            target.AddBid(memberParam, amountParam);

            // asercje - weryfikacja wyniku
            Assert.AreEqual(1, target.Bids.Count());
            Assert.AreEqual(amountParam, target.Bids[0].BidAmount);
        }

        [TestMethod()]
        [ExpectedException(typeof(InvalidOperationException))]
        public void CannotAddLowerBid() {

            // przygotowanie 
            Item target = new Item();
            Member memberParam = new Member();
            Decimal amountParam = 150M;

            // działanie
            target.AddBid(memberParam, amountParam);
            target.AddBid(memberParam, amountParam - 10);
        }

        [TestMethod()]
        public void CanAddHigherBid() {

            // przygotowanie
            Item target = new Item();
            Member firstMember = new Member();
            Member secondMember = new Member();
            Decimal amountParam = 150M;

            // działanie
            target.AddBid(firstMember, amountParam);
            target.AddBid(secondMember, amountParam + 10);

            // asercje
            Assert.AreEqual(2, target.Bids.Count());
            Assert.AreEqual(amountParam + 10, target.Bids[1].BidAmount);
        }


    }
}
